/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.IntValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class IntValueArrayComparator
extends TypeComparator<IntValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final IntValueArray reference = new IntValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public IntValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(IntValueArray record) {
        return record.hashCode();
    }

    public void setReference(IntValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(IntValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<IntValueArray> referencedComparator) {
        int comp = ((IntValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(IntValueArray first, IntValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            int secondValue;
            int firstValue = firstSource.readInt();
            int cmp = Integer.compare(firstValue, secondValue = secondSource.readInt());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(IntValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(IntValueArray record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<IntValueArray> duplicate() {
        return new IntValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(IntValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public IntValueArray readWithKeyDenormalization(IntValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

