/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.metric.directed;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.accumulators.LongMaximum;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.asm.result.PrintableResult;

public class VertexMetrics<K extends Comparable<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private static final String VERTEX_COUNT = "vertexCount";
    private static final String UNIDIRECTIONAL_EDGE_COUNT = "unidirectionalEdgeCount";
    private static final String BIDIRECTIONAL_EDGE_COUNT = "bidirectionalEdgeCount";
    private static final String TRIPLET_COUNT = "tripletCount";
    private static final String MAXIMUM_DEGREE = "maximumDegree";
    private static final String MAXIMUM_OUT_DEGREE = "maximumOutDegree";
    private static final String MAXIMUM_IN_DEGREE = "maximumInDegree";
    private static final String MAXIMUM_TRIPLETS = "maximumTriplets";
    private VertexMetricsHelper<K> vertexMetricsHelper;
    private boolean includeZeroDegreeVertices = false;

    public VertexMetrics<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices = includeZeroDegreeVertices;
        return this;
    }

    public VertexMetrics<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        DataSet vertexDegree = (DataSet)input.run(new VertexDegrees().setIncludeZeroDegreeVertices(this.includeZeroDegreeVertices).setParallelism(this.parallelism));
        this.vertexMetricsHelper = new VertexMetricsHelper();
        vertexDegree.output(this.vertexMetricsHelper).name("Vertex metrics");
        return this;
    }

    @Override
    public Result getResult() {
        long vertexCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, VERTEX_COUNT);
        long unidirectionalEdgeCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, UNIDIRECTIONAL_EDGE_COUNT);
        long bidirectionalEdgeCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, BIDIRECTIONAL_EDGE_COUNT);
        long tripletCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, TRIPLET_COUNT);
        long maximumDegree = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_DEGREE);
        long maximumOutDegree = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_OUT_DEGREE);
        long maximumInDegree = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_IN_DEGREE);
        long maximumTriplets = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_TRIPLETS);
        return new Result(vertexCount, unidirectionalEdgeCount / 2L, bidirectionalEdgeCount / 2L, tripletCount, maximumDegree, maximumOutDegree, maximumInDegree, maximumTriplets);
    }

    public static class Result
    implements PrintableResult {
        private long vertexCount;
        private long unidirectionalEdgeCount;
        private long bidirectionalEdgeCount;
        private long tripletCount;
        private long maximumDegree;
        private long maximumOutDegree;
        private long maximumInDegree;
        private long maximumTriplets;

        public Result(long vertexCount, long unidirectionalEdgeCount, long bidirectionalEdgeCount, long tripletCount, long maximumDegree, long maximumOutDegree, long maximumInDegree, long maximumTriplets) {
            this.vertexCount = vertexCount;
            this.unidirectionalEdgeCount = unidirectionalEdgeCount;
            this.bidirectionalEdgeCount = bidirectionalEdgeCount;
            this.tripletCount = tripletCount;
            this.maximumDegree = maximumDegree;
            this.maximumOutDegree = maximumOutDegree;
            this.maximumInDegree = maximumInDegree;
            this.maximumTriplets = maximumTriplets;
        }

        public long getNumberOfVertices() {
            return this.vertexCount;
        }

        public long getNumberOfEdges() {
            return this.unidirectionalEdgeCount + 2L * this.bidirectionalEdgeCount;
        }

        public long getNumberOfDirectedEdges() {
            return this.unidirectionalEdgeCount;
        }

        public long getNumberOfUndirectedEdges() {
            return this.bidirectionalEdgeCount;
        }

        public double getAverageDegree() {
            return this.vertexCount == 0L ? Double.NaN : (double)this.getNumberOfEdges() / (double)this.vertexCount;
        }

        public double getDensity() {
            return this.vertexCount <= 1L ? Double.NaN : (double)this.getNumberOfEdges() / (double)(this.vertexCount * (this.vertexCount - 1L));
        }

        public long getNumberOfTriplets() {
            return this.tripletCount;
        }

        public long getMaximumDegree() {
            return this.maximumDegree;
        }

        public long getMaximumOutDegree() {
            return this.maximumOutDegree;
        }

        public long getMaximumInDegree() {
            return this.maximumInDegree;
        }

        public long getMaximumTriplets() {
            return this.maximumTriplets;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            NumberFormat nf = NumberFormat.getInstance();
            NumberFormat ff = NumberFormat.getInstance();
            ff.setMaximumFractionDigits(8);
            return "vertex count: " + nf.format(this.vertexCount) + "; edge count: " + nf.format(this.getNumberOfEdges()) + "; unidirectional edge count: " + nf.format(this.unidirectionalEdgeCount) + "; bidirectional edge count: " + nf.format(this.bidirectionalEdgeCount) + "; average degree: " + nf.format(this.getAverageDegree()) + "; density: " + ff.format(this.getDensity()) + "; triplet count: " + nf.format(this.tripletCount) + "; maximum degree: " + nf.format(this.maximumDegree) + "; maximum out degree: " + nf.format(this.maximumOutDegree) + "; maximum in degree: " + nf.format(this.maximumInDegree) + "; maximum triplets: " + nf.format(this.maximumTriplets);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.vertexCount).append(this.unidirectionalEdgeCount).append(this.bidirectionalEdgeCount).append(this.tripletCount).append(this.maximumDegree).append(this.maximumOutDegree).append(this.maximumInDegree).append(this.maximumTriplets).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.vertexCount, rhs.vertexCount).append(this.unidirectionalEdgeCount, rhs.unidirectionalEdgeCount).append(this.bidirectionalEdgeCount, rhs.bidirectionalEdgeCount).append(this.tripletCount, rhs.tripletCount).append(this.maximumDegree, rhs.maximumDegree).append(this.maximumOutDegree, rhs.maximumOutDegree).append(this.maximumInDegree, rhs.maximumInDegree).append(this.maximumTriplets, rhs.maximumTriplets).isEquals();
        }
    }

    private static class VertexMetricsHelper<T>
    extends AnalyticHelper<Vertex<T, VertexDegrees.Degrees>> {
        private long vertexCount;
        private long unidirectionalEdgeCount;
        private long bidirectionalEdgeCount;
        private long tripletCount;
        private long maximumDegree;
        private long maximumOutDegree;
        private long maximumInDegree;
        private long maximumTriplets;

        private VertexMetricsHelper() {
        }

        public void writeRecord(Vertex<T, VertexDegrees.Degrees> record) throws IOException {
            long degree = ((VertexDegrees.Degrees)((Object)record.f1)).getDegree().getValue();
            long outDegree = ((VertexDegrees.Degrees)((Object)record.f1)).getOutDegree().getValue();
            long inDegree = ((VertexDegrees.Degrees)((Object)record.f1)).getInDegree().getValue();
            long bidirectionalEdges = outDegree + inDegree - degree;
            long triplets = degree * (degree - 1L) / 2L;
            ++this.vertexCount;
            this.unidirectionalEdgeCount += degree - bidirectionalEdges;
            this.bidirectionalEdgeCount += bidirectionalEdges;
            this.tripletCount += triplets;
            this.maximumDegree = Math.max(this.maximumDegree, degree);
            this.maximumOutDegree = Math.max(this.maximumOutDegree, outDegree);
            this.maximumInDegree = Math.max(this.maximumInDegree, inDegree);
            this.maximumTriplets = Math.max(this.maximumTriplets, triplets);
        }

        public void close() throws IOException {
            this.addAccumulator(VertexMetrics.VERTEX_COUNT, new LongCounter(this.vertexCount));
            this.addAccumulator(VertexMetrics.UNIDIRECTIONAL_EDGE_COUNT, new LongCounter(this.unidirectionalEdgeCount));
            this.addAccumulator(VertexMetrics.BIDIRECTIONAL_EDGE_COUNT, new LongCounter(this.bidirectionalEdgeCount));
            this.addAccumulator(VertexMetrics.TRIPLET_COUNT, new LongCounter(this.tripletCount));
            this.addAccumulator(VertexMetrics.MAXIMUM_DEGREE, new LongMaximum(this.maximumDegree));
            this.addAccumulator(VertexMetrics.MAXIMUM_OUT_DEGREE, new LongMaximum(this.maximumOutDegree));
            this.addAccumulator(VertexMetrics.MAXIMUM_IN_DEGREE, new LongMaximum(this.maximumInDegree));
            this.addAccumulator(VertexMetrics.MAXIMUM_TRIPLETS, new LongMaximum(this.maximumTriplets));
        }
    }
}

