/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.directed;

import java.io.IOException;
import java.math.BigInteger;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.library.clustering.directed.TriangleListing;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.Preconditions;

public class TriadicCensus<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private TriangleListingHelper<K> triangleListingHelper;
    private VertexDegreesHelper<K> vertexDegreesHelper;

    public TriadicCensus<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        this.triangleListingHelper = new TriangleListingHelper();
        ((DataSet)input.run(new TriangleListing().setParallelism(this.parallelism))).output(this.triangleListingHelper).name("Triangle counts");
        this.vertexDegreesHelper = new VertexDegreesHelper();
        ((DataSet)input.run(new VertexDegrees().setParallelism(this.parallelism))).output(this.vertexDegreesHelper).name("Edge and triplet counts");
        return this;
    }

    @Override
    public Result getResult() {
        BigInteger one = BigInteger.ONE;
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger three = BigInteger.valueOf(3L);
        BigInteger six = BigInteger.valueOf(6L);
        BigInteger vertexCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "vc"));
        BigInteger unidirectionalEdgeCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "uec") / 2L);
        BigInteger bidirectionalEdgeCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "bec") / 2L);
        BigInteger triplet021dCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "021d"));
        BigInteger triplet021uCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "021u"));
        BigInteger triplet021cCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "021c"));
        BigInteger triplet111dCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "111d"));
        BigInteger triplet111uCount = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "111u"));
        BigInteger triplet201Count = BigInteger.valueOf((Long)this.vertexDegreesHelper.getAccumulator(this.env, "201"));
        BigInteger triangle030tCount = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "030t"));
        BigInteger triangle030cCount = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "030c"));
        BigInteger triangle120dCount = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "120d"));
        BigInteger triangle120uCount = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "120u"));
        BigInteger triangle120cCount = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "120c"));
        BigInteger triangle210Count = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "210"));
        BigInteger triangle300Count = BigInteger.valueOf((Long)this.triangleListingHelper.getAccumulator(this.env, "300"));
        triplet201Count = triplet201Count.subtract(triangle300Count.multiply(three));
        triplet201Count = triplet201Count.subtract(triangle210Count);
        triplet111dCount = triplet111dCount.subtract(triangle210Count);
        triplet111uCount = triplet111uCount.subtract(triangle210Count);
        triplet111dCount = triplet111dCount.subtract(triangle120cCount);
        triplet111uCount = triplet111uCount.subtract(triangle120cCount);
        triplet021cCount = triplet021cCount.subtract(triangle120cCount);
        triplet111uCount = triplet111uCount.subtract(triangle120uCount.multiply(two));
        triplet021uCount = triplet021uCount.subtract(triangle120uCount);
        triplet111dCount = triplet111dCount.subtract(triangle120dCount.multiply(two));
        triplet021dCount = triplet021dCount.subtract(triangle120dCount);
        triplet021cCount = triplet021cCount.subtract(triangle030cCount.multiply(three));
        triplet021cCount = triplet021cCount.subtract(triangle030tCount);
        triplet021uCount = triplet021uCount.subtract(triangle030tCount);
        triplet021dCount = triplet021dCount.subtract(triangle030tCount);
        BigInteger edge102 = bidirectionalEdgeCount.multiply(vertexCount.subtract(two)).subtract(triplet111dCount).subtract(triplet111uCount).subtract(triplet201Count.multiply(two)).subtract(triangle120dCount).subtract(triangle120uCount).subtract(triangle120cCount).subtract(triangle210Count.multiply(two)).subtract(triangle300Count.multiply(three));
        BigInteger edge012 = unidirectionalEdgeCount.multiply(vertexCount.subtract(two)).subtract(triplet021dCount.multiply(two)).subtract(triplet021uCount.multiply(two)).subtract(triplet021cCount.multiply(two)).subtract(triplet111dCount).subtract(triplet111uCount).subtract(triangle030tCount.multiply(three)).subtract(triangle030cCount.multiply(three)).subtract(triangle120dCount.multiply(two)).subtract(triangle120uCount.multiply(two)).subtract(triangle120cCount.multiply(two)).subtract(triangle210Count);
        BigInteger triad003 = vertexCount.multiply(vertexCount.subtract(one)).multiply(vertexCount.subtract(two)).divide(six).subtract(edge012).subtract(edge102).subtract(triplet021dCount).subtract(triplet021uCount).subtract(triplet021cCount).subtract(triplet111dCount).subtract(triplet111uCount).subtract(triangle030tCount).subtract(triangle030cCount).subtract(triplet201Count).subtract(triangle120dCount).subtract(triangle120uCount).subtract(triangle120cCount).subtract(triangle210Count).subtract(triangle300Count);
        return new Result(triad003, edge012, edge102, triplet021dCount, triplet021uCount, triplet021cCount, triplet111dCount, triplet111uCount, triangle030tCount, triangle030cCount, triplet201Count, triangle120dCount, triangle120uCount, triangle120cCount, triangle210Count, triangle300Count);
    }

    public static class Result
    implements PrintableResult {
        private final BigInteger[] counts;

        public Result(BigInteger ... counts) {
            Preconditions.checkArgument((counts.length == 16 ? 1 : 0) != 0, (Object)("Expected 16 counts but received " + counts.length));
            this.counts = counts;
        }

        public Result(long ... counts) {
            Preconditions.checkArgument((counts.length == 16 ? 1 : 0) != 0, (Object)("Expected 16 counts but received " + counts.length));
            this.counts = new BigInteger[counts.length];
            for (int i = 0; i < counts.length; ++i) {
                this.counts[i] = BigInteger.valueOf(counts[i]);
            }
        }

        public BigInteger getCount003() {
            return this.counts[0];
        }

        public BigInteger getCount012() {
            return this.counts[1];
        }

        public BigInteger getCount102() {
            return this.counts[2];
        }

        public BigInteger getCount021d() {
            return this.counts[3];
        }

        public BigInteger getCount021u() {
            return this.counts[4];
        }

        public BigInteger getCount021c() {
            return this.counts[5];
        }

        public BigInteger getCount111d() {
            return this.counts[6];
        }

        public BigInteger getCount111u() {
            return this.counts[7];
        }

        public BigInteger getCount030t() {
            return this.counts[8];
        }

        public BigInteger getCount030c() {
            return this.counts[9];
        }

        public BigInteger getCount201() {
            return this.counts[10];
        }

        public BigInteger getCount120d() {
            return this.counts[11];
        }

        public BigInteger getCount120u() {
            return this.counts[12];
        }

        public BigInteger getCount120c() {
            return this.counts[13];
        }

        public BigInteger getCount210() {
            return this.counts[14];
        }

        public BigInteger getCount300() {
            return this.counts[15];
        }

        public BigInteger[] getCounts() {
            return this.counts;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            NumberFormat nf = NumberFormat.getInstance();
            return "003: " + nf.format(this.getCount003()) + "; 012: " + nf.format(this.getCount012()) + "; 102: " + nf.format(this.getCount102()) + "; 021d: " + nf.format(this.getCount021d()) + "; 021u: " + nf.format(this.getCount021u()) + "; 021c: " + nf.format(this.getCount021c()) + "; 111d: " + nf.format(this.getCount111d()) + "; 111u: " + nf.format(this.getCount111u()) + "; 030t: " + nf.format(this.getCount030t()) + "; 030c: " + nf.format(this.getCount030c()) + "; 201: " + nf.format(this.getCount201()) + "; 120d: " + nf.format(this.getCount120d()) + "; 120u: " + nf.format(this.getCount120u()) + "; 120c: " + nf.format(this.getCount120c()) + "; 210: " + nf.format(this.getCount210()) + "; 300: " + nf.format(this.getCount300());
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object[])this.counts).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append((Object[])this.counts, (Object[])rhs.counts).isEquals();
        }
    }

    private static class VertexDegreesHelper<T>
    extends AnalyticHelper<Vertex<T, VertexDegrees.Degrees>> {
        private long vertexCount;
        private long unidirectionalEdgeCount;
        private long bidirectionalEdgeCount;
        private long triplet021dCount;
        private long triplet021uCount;
        private long triplet021cCount;
        private long triplet111dCount;
        private long triplet111uCount;
        private long triplet201Count;

        private VertexDegreesHelper() {
        }

        public void writeRecord(Vertex<T, VertexDegrees.Degrees> record) throws IOException {
            long degree = ((VertexDegrees.Degrees)((Object)record.f1)).getDegree().getValue();
            long outDegree = ((VertexDegrees.Degrees)((Object)record.f1)).getOutDegree().getValue();
            long inDegree = ((VertexDegrees.Degrees)((Object)record.f1)).getInDegree().getValue();
            long unidirectionalEdgesAsSource = degree - inDegree;
            long unidirectionalEdgesAsTarget = degree - outDegree;
            long bidirectionalEdges = inDegree + outDegree - degree;
            ++this.vertexCount;
            this.unidirectionalEdgeCount += unidirectionalEdgesAsSource + unidirectionalEdgesAsTarget;
            this.bidirectionalEdgeCount += bidirectionalEdges;
            this.triplet021dCount += unidirectionalEdgesAsSource * (unidirectionalEdgesAsSource - 1L) / 2L;
            this.triplet021uCount += unidirectionalEdgesAsTarget * (unidirectionalEdgesAsTarget - 1L) / 2L;
            this.triplet021cCount += unidirectionalEdgesAsSource * unidirectionalEdgesAsTarget;
            this.triplet111dCount += unidirectionalEdgesAsTarget * bidirectionalEdges;
            this.triplet111uCount += unidirectionalEdgesAsSource * bidirectionalEdges;
            this.triplet201Count += bidirectionalEdges * (bidirectionalEdges - 1L) / 2L;
        }

        public void close() throws IOException {
            this.addAccumulator("vc", new LongCounter(this.vertexCount));
            this.addAccumulator("uec", new LongCounter(this.unidirectionalEdgeCount));
            this.addAccumulator("bec", new LongCounter(this.bidirectionalEdgeCount));
            this.addAccumulator("021d", new LongCounter(this.triplet021dCount));
            this.addAccumulator("021u", new LongCounter(this.triplet021uCount));
            this.addAccumulator("021c", new LongCounter(this.triplet021cCount));
            this.addAccumulator("111d", new LongCounter(this.triplet111dCount));
            this.addAccumulator("111u", new LongCounter(this.triplet111uCount));
            this.addAccumulator("201", new LongCounter(this.triplet201Count));
        }
    }

    private static class TriangleListingHelper<T>
    extends AnalyticHelper<TriangleListing.Result<T>> {
        private long[] triangleCount = new long[64];

        private TriangleListingHelper() {
        }

        public void writeRecord(TriangleListing.Result<T> record) throws IOException {
            byte by = record.getBitmask().getValue();
            this.triangleCount[by] = this.triangleCount[by] + 1L;
        }

        public void close() throws IOException {
            int[] typeTable = new int[]{1, 2, 2, 3, 2, 4, 6, 8, 2, 6, 5, 7, 3, 8, 7, 11, 2, 6, 4, 8, 5, 9, 9, 13, 6, 10, 9, 14, 7, 14, 12, 15, 2, 5, 6, 7, 6, 9, 10, 14, 4, 9, 9, 12, 8, 13, 14, 15, 3, 7, 8, 11, 7, 12, 14, 15, 8, 14, 13, 15, 11, 15, 15, 16};
            long triangle030tCount = 0L;
            long triangle030cCount = 0L;
            long triangle120dCount = 0L;
            long triangle120uCount = 0L;
            long triangle120cCount = 0L;
            long triangle210Count = 0L;
            long triangle300tCount = 0L;
            for (int i = 0; i < typeTable.length; ++i) {
                if (typeTable[i] == 9) {
                    triangle030tCount += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 10) {
                    triangle030cCount += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 12) {
                    triangle120dCount += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 13) {
                    triangle120uCount += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 14) {
                    triangle120cCount += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 15) {
                    triangle210Count += this.triangleCount[i];
                    continue;
                }
                if (typeTable[i] == 16) {
                    triangle300tCount += this.triangleCount[i];
                    continue;
                }
                assert (this.triangleCount[i] == 0L);
            }
            this.addAccumulator("030t", new LongCounter(triangle030tCount));
            this.addAccumulator("030c", new LongCounter(triangle030cCount));
            this.addAccumulator("120d", new LongCounter(triangle120dCount));
            this.addAccumulator("120u", new LongCounter(triangle120uCount));
            this.addAccumulator("120c", new LongCounter(triangle120cCount));
            this.addAccumulator("210", new LongCounter(triangle210Count));
            this.addAccumulator("300", new LongCounter(triangle300tCount));
        }
    }
}

