/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.CirculantGraph;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Preconditions;

public class EchoGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 2;
    public static final int MINIMUM_VERTEX_DEGREE = 1;
    private final ExecutionEnvironment env;
    private final long vertexCount;
    private final long vertexDegree;

    public EchoGraph(ExecutionEnvironment env, long vertexCount, long vertexDegree) {
        Preconditions.checkArgument((vertexCount >= 2L ? 1 : 0) != 0, (Object)"Vertex count must be at least 2");
        Preconditions.checkArgument((vertexDegree >= 1L ? 1 : 0) != 0, (Object)"Vertex degree must be at least 1");
        Preconditions.checkArgument((vertexDegree < vertexCount ? 1 : 0) != 0, (Object)"Vertex degree must be less than the vertex count.");
        Preconditions.checkArgument((boolean)(vertexCount % 2L == 0L ^ vertexDegree % 2L == 0L), (Object)"Vertex count or vertex degree must be an even number but not both.");
        this.env = env;
        this.vertexCount = vertexCount;
        this.vertexDegree = vertexDegree;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        return new CirculantGraph(this.env, this.vertexCount).addRange((this.vertexCount - this.vertexDegree + 1L) / 2L, this.vertexDegree).setParallelism(this.parallelism).generate();
    }
}

