/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.directed;

import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;

public class VertexInDegree<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Vertex<K, LongValue>> {
    private OptionalBoolean includeZeroDegreeVertices = new OptionalBoolean(false, true);

    public VertexInDegree<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices.set(includeZeroDegreeVertices);
        return this;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        VertexInDegree rhs = (VertexInDegree)other;
        return !this.includeZeroDegreeVertices.conflictsWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        super.mergeConfiguration(other);
        VertexInDegree rhs = (VertexInDegree)other;
        this.includeZeroDegreeVertices.mergeWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    public DataSet<Vertex<K, LongValue>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator targetIds = ((MapOperator)input.getEdges().map(new DegreeAnnotationFunctions.MapEdgeToTargetId()).setParallelism(this.parallelism)).name("Edge to target ID");
        Operator targetDegree = ((ReduceOperator)targetIds.groupBy(new int[]{0}).reduce(new DegreeAnnotationFunctions.DegreeCount()).setCombineHint(ReduceOperatorBase.CombineHint.HASH).setParallelism(this.parallelism)).name("Degree count");
        if (this.includeZeroDegreeVertices.get()) {
            targetDegree = ((JoinOperator)input.getVertices().leftOuterJoin((DataSet)targetDegree).where(new int[]{0}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinVertexWithVertexDegree()).setParallelism(this.parallelism)).name("Zero degree vertices");
        }
        return targetDegree;
    }
}

