/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.types.LongValue;

public class GraphUtils {
    private GraphUtils() {
    }

    public static <T> DataSet<LongValue> count(DataSet<T> input) {
        return ((MapOperator)((MapOperator)input.map(new MapTo(new LongValue(1L))).returns((TypeInformation)ValueTypeInfo.LONG_VALUE_TYPE_INFO)).name("Emit 1")).reduce((ReduceFunction)new AddLongValue()).name("Sum");
    }

    public static class AddLongValue
    implements ReduceFunction<LongValue> {
        public LongValue reduce(LongValue value1, LongValue value2) throws Exception {
            value1.setValue(value1.getValue() + value2.getValue());
            return value1;
        }
    }

    public static class MapTo<I, O>
    implements MapFunction<I, O>,
    ResultTypeQueryable<O>,
    TranslateFunction<I, O> {
        private final O value;

        public MapTo(O value) {
            this.value = value;
        }

        public O map(I input) throws Exception {
            return this.value;
        }

        @Override
        public O translate(I input, O reuse) throws Exception {
            return this.value;
        }

        public TypeInformation<O> getProducedType() {
            return TypeExtractor.createTypeInfo(this.value.getClass());
        }
    }

    public static final class NonForwardingIdentityMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    public static final class IdentityMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }
}

