/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.graph.types.valuearray.ByteValueArrayComparator;
import org.apache.flink.graph.types.valuearray.ByteValueArraySerializer;
import org.apache.flink.graph.types.valuearray.CharValueArrayComparator;
import org.apache.flink.graph.types.valuearray.CharValueArraySerializer;
import org.apache.flink.graph.types.valuearray.DoubleValueArrayComparator;
import org.apache.flink.graph.types.valuearray.DoubleValueArraySerializer;
import org.apache.flink.graph.types.valuearray.FloatValueArrayComparator;
import org.apache.flink.graph.types.valuearray.FloatValueArraySerializer;
import org.apache.flink.graph.types.valuearray.IntValueArrayComparator;
import org.apache.flink.graph.types.valuearray.IntValueArraySerializer;
import org.apache.flink.graph.types.valuearray.LongValueArrayComparator;
import org.apache.flink.graph.types.valuearray.LongValueArraySerializer;
import org.apache.flink.graph.types.valuearray.NullValueArrayComparator;
import org.apache.flink.graph.types.valuearray.NullValueArraySerializer;
import org.apache.flink.graph.types.valuearray.ShortValueArrayComparator;
import org.apache.flink.graph.types.valuearray.ShortValueArraySerializer;
import org.apache.flink.graph.types.valuearray.StringValueArrayComparator;
import org.apache.flink.graph.types.valuearray.StringValueArraySerializer;
import org.apache.flink.graph.types.valuearray.ValueArray;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

public class ValueArrayTypeInfo<T>
extends TypeInformation<ValueArray<T>>
implements AtomicType<ValueArray<T>> {
    private static final long serialVersionUID = 1L;
    public static final ValueArrayTypeInfo<ByteValue> BYTE_VALUE_ARRAY_TYPE_INFO = new ValueArrayTypeInfo(ValueTypeInfo.BYTE_VALUE_TYPE_INFO);
    public static final ValueArrayTypeInfo<IntValue> INT_VALUE_ARRAY_TYPE_INFO = new ValueArrayTypeInfo(ValueTypeInfo.INT_VALUE_TYPE_INFO);
    public static final ValueArrayTypeInfo<LongValue> LONG_VALUE_ARRAY_TYPE_INFO = new ValueArrayTypeInfo(ValueTypeInfo.LONG_VALUE_TYPE_INFO);
    public static final ValueArrayTypeInfo<NullValue> NULL_VALUE_ARRAY_TYPE_INFO = new ValueArrayTypeInfo(ValueTypeInfo.NULL_VALUE_TYPE_INFO);
    public static final ValueArrayTypeInfo<StringValue> STRING_VALUE_ARRAY_TYPE_INFO = new ValueArrayTypeInfo(ValueTypeInfo.STRING_VALUE_TYPE_INFO);
    private final TypeInformation<T> valueType;
    private final Class<T> type;

    public ValueArrayTypeInfo(TypeInformation<T> valueType) {
        this.valueType = valueType;
        this.type = valueType == null ? null : valueType.getTypeClass();
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<ValueArray<T>> getTypeClass() {
        return ValueArray.class;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public boolean isKeyType() {
        Preconditions.checkNotNull(this.type, (String)"TypeInformation type class is required");
        return Comparable.class.isAssignableFrom(this.type);
    }

    public TypeSerializer<ValueArray<T>> createSerializer(ExecutionConfig executionConfig) {
        Preconditions.checkNotNull(this.type, (String)"TypeInformation type class is required");
        if (ByteValue.class.isAssignableFrom(this.type)) {
            return new ByteValueArraySerializer();
        }
        if (CharValue.class.isAssignableFrom(this.type)) {
            return new CharValueArraySerializer();
        }
        if (DoubleValue.class.isAssignableFrom(this.type)) {
            return new DoubleValueArraySerializer();
        }
        if (FloatValue.class.isAssignableFrom(this.type)) {
            return new FloatValueArraySerializer();
        }
        if (IntValue.class.isAssignableFrom(this.type)) {
            return new IntValueArraySerializer();
        }
        if (LongValue.class.isAssignableFrom(this.type)) {
            return new LongValueArraySerializer();
        }
        if (NullValue.class.isAssignableFrom(this.type)) {
            return new NullValueArraySerializer();
        }
        if (ShortValue.class.isAssignableFrom(this.type)) {
            return new ShortValueArraySerializer();
        }
        if (StringValue.class.isAssignableFrom(this.type)) {
            return new StringValueArraySerializer();
        }
        throw new InvalidTypesException("No ValueArray class exists for " + this.type);
    }

    public TypeComparator<ValueArray<T>> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        Preconditions.checkNotNull(this.type, (String)"TypeInformation type class is required");
        if (ByteValue.class.isAssignableFrom(this.type)) {
            return new ByteValueArrayComparator(sortOrderAscending);
        }
        if (CharValue.class.isAssignableFrom(this.type)) {
            return new CharValueArrayComparator(sortOrderAscending);
        }
        if (DoubleValue.class.isAssignableFrom(this.type)) {
            return new DoubleValueArrayComparator(sortOrderAscending);
        }
        if (FloatValue.class.isAssignableFrom(this.type)) {
            return new FloatValueArrayComparator(sortOrderAscending);
        }
        if (IntValue.class.isAssignableFrom(this.type)) {
            return new IntValueArrayComparator(sortOrderAscending);
        }
        if (LongValue.class.isAssignableFrom(this.type)) {
            return new LongValueArrayComparator(sortOrderAscending);
        }
        if (NullValue.class.isAssignableFrom(this.type)) {
            return new NullValueArrayComparator(sortOrderAscending);
        }
        if (ShortValue.class.isAssignableFrom(this.type)) {
            return new ShortValueArrayComparator(sortOrderAscending);
        }
        if (StringValue.class.isAssignableFrom(this.type)) {
            return new StringValueArrayComparator(sortOrderAscending);
        }
        throw new InvalidTypesException("No ValueArray class exists for " + this.type);
    }

    public Map<String, TypeInformation<?>> getGenericParameters() {
        HashMap m = new HashMap(1);
        m.put("T", this.valueType);
        return m;
    }

    public int hashCode() {
        Preconditions.checkNotNull(this.type, (String)"TypeInformation type class is required");
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueArrayTypeInfo) {
            ValueArrayTypeInfo valueArrayTypeInfo = (ValueArrayTypeInfo)((Object)obj);
            return valueArrayTypeInfo.canEqual((Object)this) && this.type == valueArrayTypeInfo.type;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ValueArrayTypeInfo;
    }

    public String toString() {
        Preconditions.checkNotNull(this.type, (String)"TypeInformation type class is required");
        return "ValueArrayType<" + this.type.getSimpleName() + ">";
    }
}

