/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import org.apache.flink.graph.types.valuearray.ByteValueArray;
import org.apache.flink.graph.types.valuearray.CharValueArray;
import org.apache.flink.graph.types.valuearray.DoubleValueArray;
import org.apache.flink.graph.types.valuearray.FloatValueArray;
import org.apache.flink.graph.types.valuearray.IntValueArray;
import org.apache.flink.graph.types.valuearray.LongValueArray;
import org.apache.flink.graph.types.valuearray.NullValueArray;
import org.apache.flink.graph.types.valuearray.ShortValueArray;
import org.apache.flink.graph.types.valuearray.StringValueArray;
import org.apache.flink.graph.types.valuearray.ValueArray;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public class ValueArrayFactory {
    public static <T> ValueArray<T> createValueArray(Class<? extends Value> cls) {
        if (ByteValue.class.isAssignableFrom(cls)) {
            return new ByteValueArray();
        }
        if (CharValue.class.isAssignableFrom(cls)) {
            return new CharValueArray();
        }
        if (DoubleValue.class.isAssignableFrom(cls)) {
            return new DoubleValueArray();
        }
        if (FloatValue.class.isAssignableFrom(cls)) {
            return new FloatValueArray();
        }
        if (IntValue.class.isAssignableFrom(cls)) {
            return new IntValueArray();
        }
        if (LongValue.class.isAssignableFrom(cls)) {
            return new LongValueArray();
        }
        if (NullValue.class.isAssignableFrom(cls)) {
            return new NullValueArray();
        }
        if (ShortValue.class.isAssignableFrom(cls)) {
            return new ShortValueArray();
        }
        if (StringValue.class.isAssignableFrom(cls)) {
            return new StringValueArray();
        }
        throw new IllegalArgumentException("Unable to create unbounded ValueArray for type " + cls);
    }

    public static <T> ValueArray<T> createValueArray(Class<? extends Value> cls, int bytes) {
        if (ByteValue.class.isAssignableFrom(cls)) {
            return new ByteValueArray(bytes);
        }
        if (CharValue.class.isAssignableFrom(cls)) {
            return new CharValueArray(bytes);
        }
        if (DoubleValue.class.isAssignableFrom(cls)) {
            return new DoubleValueArray(bytes);
        }
        if (FloatValue.class.isAssignableFrom(cls)) {
            return new FloatValueArray(bytes);
        }
        if (IntValue.class.isAssignableFrom(cls)) {
            return new IntValueArray(bytes);
        }
        if (LongValue.class.isAssignableFrom(cls)) {
            return new LongValueArray(bytes);
        }
        if (NullValue.class.isAssignableFrom(cls)) {
            return new NullValueArray(bytes);
        }
        if (ShortValue.class.isAssignableFrom(cls)) {
            return new ShortValueArray(bytes);
        }
        if (StringValue.class.isAssignableFrom(cls)) {
            return new StringValueArray(bytes);
        }
        throw new IllegalArgumentException("Unable to create bounded ValueArray for type " + cls);
    }
}

