/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.LongValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class LongValueArrayComparator
extends TypeComparator<LongValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final LongValueArray reference = new LongValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public LongValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(LongValueArray record) {
        return record.hashCode();
    }

    public void setReference(LongValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(LongValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<LongValueArray> referencedComparator) {
        int comp = ((LongValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(LongValueArray first, LongValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            long secondValue;
            long firstValue = firstSource.readLong();
            int cmp = Long.compare(firstValue, secondValue = secondSource.readLong());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(LongValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(LongValueArray record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<LongValueArray> duplicate() {
        return new LongValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(LongValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public LongValueArray readWithKeyDenormalization(LongValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

