/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.DoubleValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class DoubleValueArrayComparator
extends TypeComparator<DoubleValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final DoubleValueArray reference = new DoubleValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public DoubleValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(DoubleValueArray record) {
        return record.hashCode();
    }

    public void setReference(DoubleValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(DoubleValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<DoubleValueArray> referencedComparator) {
        int comp = ((DoubleValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(DoubleValueArray first, DoubleValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            double secondValue;
            double firstValue = firstSource.readDouble();
            int cmp = Double.compare(firstValue, secondValue = secondSource.readDouble());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(DoubleValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyDoubles) {
        return keyDoubles < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(DoubleValueArray record, MemorySegment target, int offset, int numDoubles) {
        record.copyNormalizedKey(target, offset, numDoubles);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<DoubleValueArray> duplicate() {
        return new DoubleValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(DoubleValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DoubleValueArray readWithKeyDenormalization(DoubleValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

