/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.asm.result.UnaryResultBase;
import org.apache.flink.graph.library.clustering.undirected.TriangleListing;
import org.apache.flink.graph.utils.MurmurHash;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;

public class LocalClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Result<K>> {
    private OptionalBoolean includeZeroDegreeVertices = new OptionalBoolean(true, true);

    public LocalClusteringCoefficient<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices.set(includeZeroDegreeVertices);
        return this;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        LocalClusteringCoefficient rhs = (LocalClusteringCoefficient)other;
        return !this.includeZeroDegreeVertices.conflictsWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        super.mergeConfiguration(other);
        LocalClusteringCoefficient rhs = (LocalClusteringCoefficient)other;
        this.includeZeroDegreeVertices.mergeWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    public DataSet<Result<K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet triangles = (DataSet)input.run(new TriangleListing().setParallelism(this.parallelism));
        Operator triangleVertices = triangles.flatMap(new SplitTriangles()).name("Split triangle vertices");
        Operator vertexTriangleCount = ((ReduceOperator)triangleVertices.groupBy(new int[]{0}).reduce(new CountTriangles()).setCombineHint(ReduceOperatorBase.CombineHint.HASH).name("Count triangles")).setParallelism(this.parallelism);
        DataSet vertexDegree = (DataSet)input.run(new VertexDegree().setIncludeZeroDegreeVertices(this.includeZeroDegreeVertices.get()).setParallelism(this.parallelism));
        return ((JoinOperator)vertexDegree.leftOuterJoin((DataSet)vertexTriangleCount).where(new int[]{0}).equalTo(new int[]{0}).with(new JoinVertexDegreeWithTriangleCount()).setParallelism(this.parallelism)).name("Clustering coefficient");
    }

    public static class Result<T>
    extends UnaryResultBase<T>
    implements PrintableResult {
        private LongValue degree;
        private LongValue triangleCount;
        public static final int HASH_SEED = -1036437567;
        private transient MurmurHash hasher;

        public LongValue getDegree() {
            return this.degree;
        }

        public void setDegree(LongValue degree) {
            this.degree = degree;
        }

        public LongValue getTriangleCount() {
            return this.triangleCount;
        }

        public void setTriangleCount(LongValue triangleCount) {
            this.triangleCount = triangleCount;
        }

        public double getLocalClusteringCoefficientScore() {
            long degree = this.getDegree().getValue();
            long neighborPairs = degree * (degree - 1L) / 2L;
            return neighborPairs == 0L ? Double.NaN : (double)this.getTriangleCount().getValue() / (double)neighborPairs;
        }

        @Override
        public String toString() {
            return "(" + this.getVertexId0() + "," + this.degree + "," + this.triangleCount + ")";
        }

        @Override
        public String toPrintableString() {
            return "Vertex ID: " + this.getVertexId0() + ", vertex degree: " + this.degree + ", triangle count: " + this.triangleCount + ", local clustering coefficient: " + this.getLocalClusteringCoefficientScore();
        }

        public int hashCode() {
            if (this.hasher == null) {
                this.hasher = new MurmurHash(-1036437567);
            }
            return this.hasher.reset().hash(this.getVertexId0().hashCode()).hash(this.degree.getValue()).hash(this.triangleCount.getValue()).hash();
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->vertexId0; 1->degree"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0->vertexId0"})
    private static class JoinVertexDegreeWithTriangleCount<T>
    implements JoinFunction<Vertex<T, LongValue>, Tuple2<T, LongValue>, Result<T>> {
        private LongValue zero = new LongValue(0L);
        private Result<T> output = new Result();

        private JoinVertexDegreeWithTriangleCount() {
        }

        public Result<T> join(Vertex<T, LongValue> vertexAndDegree, Tuple2<T, LongValue> vertexAndTriangleCount) throws Exception {
            this.output.setVertexId0(vertexAndDegree.f0);
            this.output.setDegree((LongValue)vertexAndDegree.f1);
            this.output.setTriangleCount(vertexAndTriangleCount == null ? this.zero : (LongValue)vertexAndTriangleCount.f1);
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class CountTriangles<T>
    implements ReduceFunction<Tuple2<T, LongValue>> {
        private CountTriangles() {
        }

        public Tuple2<T, LongValue> reduce(Tuple2<T, LongValue> left, Tuple2<T, LongValue> right) throws Exception {
            ((LongValue)left.f1).setValue(((LongValue)left.f1).getValue() + ((LongValue)right.f1).getValue());
            return left;
        }
    }

    private static class SplitTriangles<T>
    implements FlatMapFunction<TriangleListing.Result<T>, Tuple2<T, LongValue>> {
        private Tuple2<T, LongValue> output = new Tuple2(null, (Object)new LongValue(1L));

        private SplitTriangles() {
        }

        public void flatMap(TriangleListing.Result<T> value, Collector<Tuple2<T, LongValue>> out) throws Exception {
            this.output.f0 = value.getVertexId0();
            out.collect(this.output);
            this.output.f0 = value.getVertexId1();
            out.collect(this.output);
            this.output.f0 = value.getVertexId2();
            out.collect(this.output);
        }
    }
}

