/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.Either;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;

public class Summarization<K, VV, EV>
implements GraphAlgorithm<K, VV, EV, Graph<K, VertexValue<VV>, EdgeValue<EV>>> {
    @Override
    public Graph<K, VertexValue<VV>, EdgeValue<EV>> run(Graph<K, VV, EV> input) throws Exception {
        GroupReduceOperator vertexGroupItems = input.getVertices().groupBy(new int[]{1}).reduceGroup(new VertexGroupReducer());
        MapOperator summarizedVertices = vertexGroupItems.filter(new VertexGroupItemToSummarizedVertexFilter()).map(new VertexGroupItemToSummarizedVertexMapper());
        MapOperator vertexToRepresentativeMap = vertexGroupItems.filter(new VertexGroupItemToRepresentativeFilter()).map(new VertexGroupItemToVertexWithRepresentativeMapper());
        JoinOperator.EquiJoin edgesForGrouping = input.getEdges().join((DataSet)vertexToRepresentativeMap).where(new int[]{0}).equalTo(new int[]{0}).with(new SourceVertexJoinFunction()).join((DataSet)vertexToRepresentativeMap).where(new int[]{1}).equalTo(new int[]{0}).with(new TargetVertexJoinFunction());
        GroupReduceOperator summarizedEdges = edgesForGrouping.groupBy(new int[]{0, 1, 2}).reduceGroup(new EdgeGroupReducer());
        return Graph.fromDataSet(summarizedVertices, summarizedEdges, input.getContext());
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f0;f2"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1"})
    private static final class TargetVertexJoinFunction<K, EV>
    implements JoinFunction<Edge<K, EV>, VertexWithRepresentative<K>, Edge<K, EV>> {
        private TargetVertexJoinFunction() {
        }

        public Edge<K, EV> join(Edge<K, EV> edge, VertexWithRepresentative<K> vertexRepresentative) throws Exception {
            edge.setTarget(vertexRepresentative.getGroupRepresentativeId());
            return edge;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f0"})
    private static final class SourceVertexJoinFunction<K, EV>
    implements JoinFunction<Edge<K, EV>, VertexWithRepresentative<K>, Edge<K, EV>> {
        private final Edge<K, EV> reuseEdge = new Edge();

        private SourceVertexJoinFunction() {
        }

        public Edge<K, EV> join(Edge<K, EV> edge, VertexWithRepresentative<K> vertex) throws Exception {
            this.reuseEdge.setSource(vertex.getGroupRepresentativeId());
            this.reuseEdge.setTarget(edge.getTarget());
            this.reuseEdge.setValue(edge.getValue());
            return this.reuseEdge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0;f1"})
    private static final class VertexGroupItemToVertexWithRepresentativeMapper<K, VV>
    implements MapFunction<VertexGroupItem<K, VV>, VertexWithRepresentative<K>> {
        private final VertexWithRepresentative<K> reuseVertexWithRepresentative = new VertexWithRepresentative();

        private VertexGroupItemToVertexWithRepresentativeMapper() {
        }

        public VertexWithRepresentative<K> map(VertexGroupItem<K, VV> vertexGroupItem) throws Exception {
            this.reuseVertexWithRepresentative.setVertexId(vertexGroupItem.getVertexId());
            this.reuseVertexWithRepresentative.setGroupRepresentativeId(vertexGroupItem.getGroupRepresentativeId());
            return this.reuseVertexWithRepresentative;
        }
    }

    private static final class VertexGroupItemToSummarizedVertexMapper<K, VV>
    implements MapFunction<VertexGroupItem<K, VV>, Vertex<K, VertexValue<VV>>> {
        private final VertexValue<VV> reuseSummarizedVertexValue = new VertexValue();

        private VertexGroupItemToSummarizedVertexMapper() {
        }

        public Vertex<K, VertexValue<VV>> map(VertexGroupItem<K, VV> value) throws Exception {
            K vertexId = value.getVertexId();
            this.reuseSummarizedVertexValue.setVertexGroupValue(value.getVertexGroupValue());
            this.reuseSummarizedVertexValue.setVertexGroupCount(value.getVertexGroupCount());
            return new Vertex<K, VertexValue<VV>>(vertexId, this.reuseSummarizedVertexValue);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->*"})
    private static final class VertexGroupItemToRepresentativeFilter<K, VV>
    implements FilterFunction<VertexGroupItem<K, VV>> {
        private VertexGroupItemToRepresentativeFilter() {
        }

        public boolean filter(VertexGroupItem<K, VV> vertexGroupItem) throws Exception {
            return vertexGroupItem.getVertexGroupCount().equals(0L);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->*"})
    private static final class VertexGroupItemToSummarizedVertexFilter<K, VV>
    implements FilterFunction<VertexGroupItem<K, VV>> {
        private VertexGroupItemToSummarizedVertexFilter() {
        }

        public boolean filter(VertexGroupItem<K, VV> vertexGroupItem) throws Exception {
            return !vertexGroupItem.getVertexGroupCount().equals(0L);
        }
    }

    private static final class EdgeGroupReducer<K, EV>
    implements GroupReduceFunction<Edge<K, EV>, Edge<K, EdgeValue<EV>>> {
        private final Edge<K, EdgeValue<EV>> reuseEdge = new Edge();
        private final EdgeValue<EV> reuseEdgeValue = new EdgeValue();

        private EdgeGroupReducer() {
        }

        public void reduce(Iterable<Edge<K, EV>> values, Collector<Edge<K, EdgeValue<EV>>> out) throws Exception {
            Object sourceVertexId = null;
            Object targetVertexId = null;
            Object edgeGroupValue = null;
            Long edgeGroupCount = 0L;
            boolean isFirstElement = true;
            for (Edge<K, EV> edge : values) {
                if (isFirstElement) {
                    sourceVertexId = edge.getSource();
                    targetVertexId = edge.getTarget();
                    edgeGroupValue = edge.getValue();
                    isFirstElement = false;
                }
                Long l = edgeGroupCount;
                Long l2 = edgeGroupCount = Long.valueOf(edgeGroupCount + 1L);
            }
            this.reuseEdgeValue.setEdgeGroupValue(edgeGroupValue);
            this.reuseEdgeValue.setEdgeGroupCount(edgeGroupCount);
            this.reuseEdge.setSource(sourceVertexId);
            this.reuseEdge.setTarget(targetVertexId);
            this.reuseEdge.setValue(this.reuseEdgeValue);
            out.collect(this.reuseEdge);
        }
    }

    private static final class VertexGroupReducer<K, VV>
    extends RichGroupReduceFunction<Vertex<K, VV>, VertexGroupItem<K, VV>> {
        private transient VertexGroupItem<K, VV> reuseVertexGroupItem;

        private VertexGroupReducer() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.reuseVertexGroupItem = new VertexGroupItem();
        }

        public void reduce(Iterable<Vertex<K, VV>> values, Collector<VertexGroupItem<K, VV>> out) throws Exception {
            Object vertexGroupRepresentativeID = null;
            long vertexGroupCount = 0L;
            VV vertexGroupValue = null;
            boolean isFirstElement = true;
            for (Vertex<K, VV> vertex : values) {
                if (isFirstElement) {
                    vertexGroupRepresentativeID = vertex.getId();
                    vertexGroupValue = vertex.getValue();
                    isFirstElement = false;
                }
                this.reuseVertexGroupItem.setVertexId(vertex.getId());
                this.reuseVertexGroupItem.setGroupRepresentativeId(vertexGroupRepresentativeID);
                out.collect(this.reuseVertexGroupItem);
                ++vertexGroupCount;
            }
            this.createGroupRepresentativeTuple(vertexGroupRepresentativeID, vertexGroupValue, vertexGroupCount);
            out.collect(this.reuseVertexGroupItem);
            this.reuseVertexGroupItem.reset();
        }

        private void createGroupRepresentativeTuple(K vertexGroupRepresentativeId, VV vertexGroupValue, Long vertexGroupCount) {
            this.reuseVertexGroupItem.setVertexId(vertexGroupRepresentativeId);
            this.reuseVertexGroupItem.setVertexGroupValue(vertexGroupValue);
            this.reuseVertexGroupItem.setVertexGroupCount(vertexGroupCount);
        }
    }

    public static final class VertexWithRepresentative<K>
    extends Tuple2<K, K> {
        public void setVertexId(K vertexId) {
            this.f0 = vertexId;
        }

        public K getGroupRepresentativeId() {
            return (K)this.f1;
        }

        public void setGroupRepresentativeId(K groupRepresentativeId) {
            this.f1 = groupRepresentativeId;
        }
    }

    public static final class VertexGroupItem<K, VGV>
    extends Tuple4<K, K, Either<VGV, NullValue>, Long> {
        private final Either.Right<VGV, NullValue> nullValue = new Either.Right((Object)NullValue.getInstance());

        public VertexGroupItem() {
            this.reset();
        }

        public K getVertexId() {
            return (K)this.f0;
        }

        public void setVertexId(K vertexId) {
            this.f0 = vertexId;
        }

        public K getGroupRepresentativeId() {
            return (K)this.f1;
        }

        public void setGroupRepresentativeId(K groupRepresentativeId) {
            this.f1 = groupRepresentativeId;
        }

        public VGV getVertexGroupValue() {
            return (VGV)(((Either)this.f2).isLeft() ? ((Either)this.f2).left() : null);
        }

        public void setVertexGroupValue(VGV vertexGroupValue) {
            this.f2 = vertexGroupValue == null ? this.nullValue : new Either.Left(vertexGroupValue);
        }

        public Long getVertexGroupCount() {
            return (Long)this.f3;
        }

        public void setVertexGroupCount(Long vertexGroupCount) {
            this.f3 = vertexGroupCount;
        }

        public void reset() {
            this.f0 = null;
            this.f1 = null;
            this.f2 = this.nullValue;
            this.f3 = 0L;
        }
    }

    public static final class EdgeValue<EV>
    extends Tuple2<EV, Long> {
        public EV getEdgeGroupValue() {
            return (EV)this.f0;
        }

        public void setEdgeGroupValue(EV edgeGroupValue) {
            this.f0 = edgeGroupValue;
        }

        public Long getEdgeGroupCount() {
            return (Long)this.f1;
        }

        public void setEdgeGroupCount(Long edgeGroupCount) {
            this.f1 = edgeGroupCount;
        }
    }

    public static final class VertexValue<VV>
    extends Tuple2<VV, Long> {
        public VV getVertexGroupValue() {
            return (VV)this.f0;
        }

        public void setVertexGroupValue(VV vertexGroupValue) {
            this.f0 = vertexGroupValue;
        }

        public Long getVertexGroupCount() {
            return (Long)this.f1;
        }

        public void setVertexGroupCount(Long vertexGroupCount) {
            this.f1 = vertexGroupCount;
        }
    }
}

