/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator.random;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.flink.graph.generator.random.GeneratorFactoryBase;
import org.apache.flink.graph.generator.random.RandomGenerable;

public class MersenneTwisterFactory
extends GeneratorFactoryBase<MersenneTwister> {
    public static final long DEFAULT_SEED = 8415200798306848441L;
    public static final int MINIMUM_CYCLES_PER_BLOCK = 0x100000;
    private final MersenneTwister random = new MersenneTwister();

    public MersenneTwisterFactory() {
        this(8415200798306848441L);
    }

    public MersenneTwisterFactory(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    protected int getMinimumCyclesPerBlock() {
        return 0x100000;
    }

    protected MersenneTwisterGenerable next() {
        return new MersenneTwisterGenerable(this.random.nextLong());
    }

    private static class MersenneTwisterGenerable
    implements RandomGenerable<MersenneTwister> {
        private final long seed;

        public MersenneTwisterGenerable(long seed) {
            this.seed = seed;
        }

        @Override
        public MersenneTwister generator() {
            MersenneTwister random = new MersenneTwister();
            random.setSeed(this.seed);
            return random;
        }
    }
}

