/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Preconditions;

public class EmptyGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 0;
    private final ExecutionEnvironment env;
    private final long vertexCount;

    public EmptyGraph(ExecutionEnvironment env, long vertexCount) {
        Preconditions.checkArgument((vertexCount >= 0L ? 1 : 0) != 0, (Object)"Vertex count must be at least 0");
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        Preconditions.checkState((this.vertexCount >= 0L ? 1 : 0) != 0);
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        DataSource edges = (DataSource)((DataSource)this.env.fromCollection(Collections.emptyList(), TypeInformation.of((TypeHint)new TypeHint<Edge<LongValue, NullValue>>(){})).setParallelism(this.parallelism)).name("Empty edge set");
        return Graph.fromDataSet(vertices, edges, this.env);
    }
}

