/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate.translators;

import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;

public class LongValueToUnsignedIntValue
implements TranslateFunction<LongValue, IntValue> {
    public static final long MAX_VERTEX_COUNT = 0x100000000L;

    @Override
    public IntValue translate(LongValue value, IntValue reuse) throws Exception {
        long l;
        if (reuse == null) {
            reuse = new IntValue();
        }
        if ((l = value.getValue()) < 0L || l >= 0x100000000L) {
            throw new IllegalArgumentException("Cannot cast long value " + value + " to integer.");
        }
        reuse.setValue((int)(l & 0xFFFFFFFFL));
        return reuse;
    }
}

