/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.core.fs.Path;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.utils.Tuple2ToEdgeMap;
import org.apache.flink.graph.utils.Tuple2ToVertexMap;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Preconditions;

public class GraphCsvReader {
    private final Path vertexPath;
    private final Path edgePath;
    private final ExecutionEnvironment executionContext;
    protected CsvReader edgeReader;
    protected CsvReader vertexReader;
    protected MapFunction<?, ?> mapper;

    public GraphCsvReader(Path vertexPath, Path edgePath, ExecutionEnvironment context) {
        this.vertexPath = vertexPath;
        this.edgePath = edgePath;
        this.vertexReader = new CsvReader(vertexPath, context);
        this.edgeReader = new CsvReader(edgePath, context);
        this.mapper = null;
        this.executionContext = context;
    }

    public GraphCsvReader(Path edgePath, ExecutionEnvironment context) {
        this.vertexPath = null;
        this.edgePath = edgePath;
        this.edgeReader = new CsvReader(edgePath, context);
        this.vertexReader = null;
        this.mapper = null;
        this.executionContext = context;
    }

    public <K, VV> GraphCsvReader(Path edgePath, MapFunction<K, VV> mapper, ExecutionEnvironment context) {
        this.vertexPath = null;
        this.edgePath = edgePath;
        this.edgeReader = new CsvReader(edgePath, context);
        this.vertexReader = null;
        this.mapper = mapper;
        this.executionContext = context;
    }

    public GraphCsvReader(String edgePath, ExecutionEnvironment context) {
        this(new Path((String)Preconditions.checkNotNull((Object)edgePath, (String)"The file path may not be null.")), context);
    }

    public GraphCsvReader(String vertexPath, String edgePath, ExecutionEnvironment context) {
        this(new Path((String)Preconditions.checkNotNull((Object)vertexPath, (String)"The file path may not be null.")), new Path((String)Preconditions.checkNotNull((Object)edgePath, (String)"The file path may not be null.")), context);
    }

    public <K, VV> GraphCsvReader(String edgePath, MapFunction<K, VV> mapper, ExecutionEnvironment context) {
        this(new Path((String)Preconditions.checkNotNull((Object)edgePath, (String)"The file path may not be null.")), mapper, context);
    }

    public <K, VV, EV> Graph<K, VV, EV> types(Class<K> vertexKey, Class<VV> vertexValue, Class<EV> edgeValue) {
        if (this.edgeReader == null) {
            throw new RuntimeException("The edge input file cannot be null!");
        }
        DataSource edges = this.edgeReader.types(vertexKey, vertexKey, edgeValue);
        if (this.vertexReader != null) {
            Operator vertices = this.vertexReader.types(vertexKey, vertexValue).name(GraphCsvReader.class.getName());
            return Graph.fromTupleDataSet(vertices, edges, this.executionContext);
        }
        if (this.mapper != null) {
            return Graph.fromTupleDataSet(edges, this.mapper, this.executionContext);
        }
        throw new RuntimeException("Vertex values have to be specified through a vertices input fileor a user-defined map function.");
    }

    public <K, EV> Graph<K, NullValue, EV> edgeTypes(Class<K> vertexKey, Class<EV> edgeValue) {
        if (this.edgeReader == null) {
            throw new RuntimeException("The edge input file cannot be null!");
        }
        Operator edges = this.edgeReader.types(vertexKey, vertexKey, edgeValue).name(GraphCsvReader.class.getName());
        return Graph.fromTupleDataSet(edges, this.executionContext);
    }

    public <K> Graph<K, NullValue, NullValue> keyType(Class<K> vertexKey) {
        if (this.edgeReader == null) {
            throw new RuntimeException("The edge input file cannot be null!");
        }
        Operator edges = ((DataSource)this.edgeReader.types(vertexKey, vertexKey).name(GraphCsvReader.class.getName())).map(new Tuple2ToEdgeMap()).name("Type conversion");
        return Graph.fromDataSet(edges, this.executionContext);
    }

    public <K, VV> Graph<K, VV, NullValue> vertexTypes(Class<K> vertexKey, Class<VV> vertexValue) {
        if (this.edgeReader == null) {
            throw new RuntimeException("The edge input file cannot be null!");
        }
        Operator edges = ((DataSource)this.edgeReader.types(vertexKey, vertexKey).name(GraphCsvReader.class.getName())).map(new Tuple2ToEdgeMap()).name("To Edge");
        if (this.vertexReader != null) {
            Operator vertices = ((DataSource)this.vertexReader.types(vertexKey, vertexValue).name(GraphCsvReader.class.getName())).map(new Tuple2ToVertexMap()).name("Type conversion");
            return Graph.fromDataSet(vertices, edges, this.executionContext);
        }
        if (this.mapper != null) {
            return Graph.fromDataSet(edges, this.mapper, this.executionContext);
        }
        throw new RuntimeException("Vertex values have to be specified through a vertices input fileor a user-defined map function.");
    }

    public GraphCsvReader lineDelimiterEdges(String delimiter) {
        this.edgeReader.lineDelimiter(delimiter);
        return this;
    }

    public GraphCsvReader lineDelimiterVertices(String delimiter) {
        if (this.vertexReader != null) {
            this.vertexReader.lineDelimiter(delimiter);
        }
        return this;
    }

    public GraphCsvReader fieldDelimiterVertices(String delimiter) {
        if (this.vertexReader != null) {
            this.vertexReader.fieldDelimiter(delimiter);
        }
        return this;
    }

    public GraphCsvReader fieldDelimiterEdges(String delimiter) {
        this.edgeReader.fieldDelimiter(delimiter);
        return this;
    }

    public GraphCsvReader parseQuotedStringsEdges(char quoteCharacter) {
        this.edgeReader.parseQuotedStrings(quoteCharacter);
        return this;
    }

    public GraphCsvReader parseQuotedStringsVertices(char quoteCharacter) {
        if (this.vertexReader != null) {
            this.vertexReader.parseQuotedStrings(quoteCharacter);
        }
        return this;
    }

    public GraphCsvReader ignoreCommentsVertices(String commentPrefix) {
        if (this.vertexReader != null) {
            this.vertexReader.ignoreComments(commentPrefix);
        }
        return this;
    }

    public GraphCsvReader ignoreCommentsEdges(String commentPrefix) {
        this.edgeReader.ignoreComments(commentPrefix);
        return this;
    }

    public GraphCsvReader includeFieldsVertices(boolean ... vertexFields) {
        if (this.vertexReader != null) {
            this.vertexReader.includeFields(vertexFields);
        }
        return this;
    }

    public GraphCsvReader includeFieldsEdges(boolean ... edgeFields) {
        this.edgeReader.includeFields(edgeFields);
        return this;
    }

    public GraphCsvReader includeFieldsVertices(String mask) {
        if (this.vertexReader != null) {
            this.vertexReader.includeFields(mask);
        }
        return this;
    }

    public GraphCsvReader includeFieldsEdges(String mask) {
        this.edgeReader.includeFields(mask);
        return this;
    }

    public GraphCsvReader includeFieldsVertices(long mask) {
        if (this.vertexReader != null) {
            this.vertexReader.includeFields(mask);
        }
        return this;
    }

    public GraphCsvReader includeFieldsEdges(long mask) {
        this.edgeReader.includeFields(mask);
        return this;
    }

    public GraphCsvReader ignoreFirstLineEdges() {
        this.edgeReader.ignoreFirstLine();
        return this;
    }

    public GraphCsvReader ignoreFirstLineVertices() {
        if (this.vertexReader != null) {
            this.vertexReader.ignoreFirstLine();
        }
        return this;
    }

    public GraphCsvReader ignoreInvalidLinesEdges() {
        this.edgeReader.ignoreInvalidLines();
        return this;
    }

    public GraphCsvReader ignoreInvalidLinesVertices() {
        if (this.vertexReader != null) {
            this.vertexReader.ignoreInvalidLines();
        }
        return this;
    }
}

