/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.validation;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.validation.GraphValidator;
import org.apache.flink.util.Collector;

public class InvalidVertexIdsValidator<K, VV, EV>
extends GraphValidator<K, VV, EV> {
    @Override
    public boolean validate(Graph<K, VV, EV> graph) throws Exception {
        DistinctOperator edgeIds = graph.getEdges().flatMap(new MapEdgeIds()).distinct();
        GroupReduceOperator invalidIds = graph.getVertices().coGroup((DataSet)edgeIds).where(new int[]{0}).equalTo(new int[]{0}).with(new GroupInvalidIds()).first(1);
        return invalidIds.map(new KToTupleMap()).count() == 0L;
    }

    private static final class KToTupleMap<K>
    implements MapFunction<K, Tuple1<K>> {
        private KToTupleMap() {
        }

        public Tuple1<K> map(K key) throws Exception {
            return new Tuple1(key);
        }
    }

    private static final class GroupInvalidIds<K, VV>
    implements CoGroupFunction<Vertex<K, VV>, Tuple1<K>, K> {
        private GroupInvalidIds() {
        }

        public void coGroup(Iterable<Vertex<K, VV>> vertexId, Iterable<Tuple1<K>> edgeId, Collector<K> out) {
            if (!vertexId.iterator().hasNext()) {
                out.collect(edgeId.iterator().next().f0);
            }
        }
    }

    private static final class MapEdgeIds<K, EV>
    implements FlatMapFunction<Edge<K, EV>, Tuple1<K>> {
        private MapEdgeIds() {
        }

        public void flatMap(Edge<K, EV> edge, Collector<Tuple1<K>> out) {
            out.collect((Object)new Tuple1(edge.f0));
            out.collect((Object)new Tuple1(edge.f1));
        }
    }
}

