/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils;

import java.io.Serializable;

public class Murmur3_32
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int seed;
    private int count;
    private int hash;

    public Murmur3_32(int seed) {
        this.seed = seed;
        this.reset();
    }

    public Murmur3_32 reset() {
        this.count = 0;
        this.hash = this.seed;
        return this;
    }

    public Murmur3_32 hash(double input) {
        this.hash(Double.doubleToLongBits(input));
        return this;
    }

    public Murmur3_32 hash(float input) {
        this.hash(Float.floatToIntBits(input));
        return this;
    }

    public Murmur3_32 hash(int input) {
        ++this.count;
        input *= -862048943;
        input = Integer.rotateLeft(input, 15);
        this.hash ^= (input *= 461845907);
        this.hash = Integer.rotateLeft(this.hash, 13);
        this.hash = this.hash * 5 + -430675100;
        return this;
    }

    public Murmur3_32 hash(long input) {
        this.hash((int)(input >>> 32));
        this.hash((int)input);
        return this;
    }

    public int hash() {
        this.hash ^= 4 * this.count;
        this.hash ^= this.hash >>> 16;
        this.hash *= -2048144789;
        this.hash ^= this.hash >>> 13;
        this.hash *= -1028477387;
        this.hash ^= this.hash >>> 16;
        return this.hash;
    }
}

