/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.spargel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.EdgeDirection;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public abstract class ScatterFunction<K, VV, Message, EV>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long numberOfVertices = -1L;
    private EdgeDirection direction;
    private Tuple2<K, Message> outValue;
    private IterationRuntimeContext runtimeContext;
    private Iterator<?> edges;
    private Collector<Tuple2<K, Message>> out;
    private K vertexId;
    private EdgesIterator<K, EV> edgeIterator;
    private boolean edgesUsed;
    private long inDegree = -1L;
    private long outDegree = -1L;

    public long getNumberOfVertices() {
        return this.numberOfVertices;
    }

    void setNumberOfVertices(long numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    public EdgeDirection getDirection() {
        return this.direction;
    }

    void setDirection(EdgeDirection direction) {
        this.direction = direction;
    }

    public abstract void sendMessages(Vertex<K, VV> var1) throws Exception;

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public Iterable<Edge<K, EV>> getEdges() {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getEdges()' or 'sendMessageToAllNeighbors()' exactly once.");
        }
        this.edgesUsed = true;
        this.edgeIterator.set(this.edges);
        return this.edgeIterator;
    }

    public void sendMessageToAllNeighbors(Message m) {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getEdges()' or 'sendMessageToAllNeighbors()'exactly once.");
        }
        this.edgesUsed = true;
        this.outValue.f1 = m;
        while (this.edges.hasNext()) {
            Tuple next = (Tuple)this.edges.next();
            if (this.getDirection().equals((Object)EdgeDirection.OUT)) {
                this.outValue.f0 = next.getField(1);
            } else if (this.getDirection().equals((Object)EdgeDirection.IN)) {
                this.outValue.f0 = next.getField(0);
            }
            if (this.getDirection().equals((Object)EdgeDirection.ALL)) {
                this.outValue.f0 = next.getField(0).equals(this.vertexId) ? next.getField(1) : next.getField(0);
            }
            this.out.collect(this.outValue);
        }
    }

    public void sendMessageTo(K target, Message m) {
        this.outValue.f0 = target;
        this.outValue.f1 = m;
        this.out.collect(this.outValue);
    }

    public int getSuperstepNumber() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    public <T> Collection<T> getBroadcastSet(String name) {
        return this.runtimeContext.getBroadcastVariable(name);
    }

    void init(IterationRuntimeContext context) {
        this.runtimeContext = context;
        this.outValue = new Tuple2();
        this.edgeIterator = new EdgesIterator();
    }

    void set(Iterator<?> edges, Collector<Tuple2<K, Message>> out, K id) {
        this.edges = edges;
        this.out = out;
        this.vertexId = id;
        this.edgesUsed = false;
    }

    public long getInDegree() {
        return this.inDegree;
    }

    void setInDegree(long inDegree) {
        this.inDegree = inDegree;
    }

    public long getOutDegree() {
        return this.outDegree;
    }

    void setOutDegree(long outDegree) {
        this.outDegree = outDegree;
    }

    private static final class EdgesIterator<K, EV>
    implements Iterator<Edge<K, EV>>,
    Iterable<Edge<K, EV>> {
        private Iterator<Edge<K, EV>> input;
        private Edge<K, EV> edge = new Edge();

        private EdgesIterator() {
        }

        void set(Iterator<Edge<K, EV>> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public Edge<K, EV> next() {
            Edge<K, EV> next = this.input.next();
            this.edge.setSource(next.f0);
            this.edge.setTarget(next.f1);
            this.edge.setValue(next.f2);
            return this.edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Edge<K, EV>> iterator() {
            return this;
        }
    }
}

