/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.similarity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeTargetDegree;
import org.apache.flink.graph.utils.Murmur3_32;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class JaccardIndex<K extends CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Result<K>> {
    public static final int DEFAULT_GROUP_SIZE = 64;
    private int groupSize = 64;
    private boolean unboundedScores = true;
    private int minimumScoreNumerator = 0;
    private int minimumScoreDenominator = 1;
    private int maximumScoreNumerator = 1;
    private int maximumScoreDenominator = 0;
    private int littleParallelism = -1;

    public JaccardIndex<K, VV, EV> setGroupSize(int groupSize) {
        Preconditions.checkArgument((groupSize > 0 ? 1 : 0) != 0, (Object)"Group size must be greater than zero");
        this.groupSize = groupSize;
        return this;
    }

    public JaccardIndex<K, VV, EV> setMinimumScore(int numerator, int denominator) {
        Preconditions.checkArgument((numerator >= 0 ? 1 : 0) != 0, (Object)"Minimum score numerator must be non-negative");
        Preconditions.checkArgument((denominator > 0 ? 1 : 0) != 0, (Object)"Minimum score denominator must be greater than zero");
        Preconditions.checkArgument((numerator <= denominator ? 1 : 0) != 0, (Object)"Minimum score fraction must be less than or equal to one");
        this.unboundedScores = false;
        this.minimumScoreNumerator = numerator;
        this.minimumScoreDenominator = denominator;
        return this;
    }

    public JaccardIndex<K, VV, EV> setMaximumScore(int numerator, int denominator) {
        Preconditions.checkArgument((numerator >= 0 ? 1 : 0) != 0, (Object)"Maximum score numerator must be non-negative");
        Preconditions.checkArgument((denominator > 0 ? 1 : 0) != 0, (Object)"Maximum score denominator must be greater than zero");
        Preconditions.checkArgument((numerator <= denominator ? 1 : 0) != 0, (Object)"Maximum score fraction must be less than or equal to one");
        this.unboundedScores = false;
        this.maximumScoreNumerator = numerator;
        this.maximumScoreDenominator = denominator;
        return this;
    }

    public JaccardIndex<K, VV, EV> setLittleParallelism(int littleParallelism) {
        Preconditions.checkArgument((littleParallelism > 0 || littleParallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.littleParallelism = littleParallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return JaccardIndex.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!JaccardIndex.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        JaccardIndex rhs = (JaccardIndex)other;
        if (this.unboundedScores != rhs.unboundedScores || this.minimumScoreNumerator != rhs.minimumScoreNumerator || this.minimumScoreDenominator != rhs.minimumScoreDenominator || this.maximumScoreNumerator != rhs.maximumScoreNumerator || this.maximumScoreDenominator != rhs.maximumScoreDenominator) {
            return false;
        }
        this.groupSize = Math.max(this.groupSize, rhs.groupSize);
        this.littleParallelism = this.littleParallelism == -1 ? rhs.littleParallelism : (rhs.littleParallelism == -1 ? this.littleParallelism : Math.min(this.littleParallelism, rhs.littleParallelism));
        return true;
    }

    @Override
    public DataSet<Result<K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet neighborDegree = (DataSet)input.run(new EdgeTargetDegree().setParallelism(this.littleParallelism));
        Operator groupSpans = ((GroupReduceOperator)neighborDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new GenerateGroupSpans(this.groupSize)).setParallelism(this.littleParallelism)).name("Generate group spans");
        Operator groups = ((FlatMapOperator)((PartitionOperator)((PartitionOperator)groupSpans.rebalance().setParallelism(this.littleParallelism)).name("Rebalance")).flatMap(new GenerateGroups()).setParallelism(this.littleParallelism)).name("Generate groups");
        Operator twoPaths = groups.groupBy(new int[]{0, 1}).sortGroup(2, Order.ASCENDING).reduceGroup(new GenerateGroupPairs(this.groupSize)).name("Generate group pairs");
        return twoPaths.groupBy(new int[]{0, 1}).reduceGroup(new ComputeScores(this.unboundedScores, this.minimumScoreNumerator, this.minimumScoreDenominator, this.maximumScoreNumerator, this.maximumScoreDenominator)).name("Compute scores");
    }

    public static class Result<T>
    extends Edge<T, Tuple2<IntValue, IntValue>> {
        public static final int HASH_SEED = 1931441127;
        private Murmur3_32 hasher = new Murmur3_32(1931441127);

        public Result() {
            this.f2 = new Tuple2((Object)new IntValue(), (Object)new IntValue());
        }

        public IntValue getSharedNeighborCount() {
            return (IntValue)((Tuple2)this.f2).f0;
        }

        public IntValue getDistinctNeighborCount() {
            return (IntValue)((Tuple2)this.f2).f1;
        }

        public double getJaccardIndexScore() {
            return (double)this.getSharedNeighborCount().getValue() / (double)this.getDistinctNeighborCount().getValue();
        }

        public String toVerboseString() {
            return "Vertex IDs: (" + this.f0 + ", " + this.f1 + "), number of shared neighbors: " + this.getSharedNeighborCount() + ", number of distinct neighbors: " + this.getDistinctNeighborCount() + ", jaccard index score: " + this.getJaccardIndexScore();
        }

        public int hashCode() {
            return this.hasher.reset().hash(this.f0.hashCode()).hash(this.f1.hashCode()).hash(((IntValue)((Tuple2)this.f2).f0).getValue()).hash(((IntValue)((Tuple2)this.f2).f1).getValue()).hash();
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static class ComputeScores<T>
    implements GroupReduceFunction<Tuple3<T, T, IntValue>, Result<T>> {
        private boolean unboundedScores;
        private long minimumScoreNumerator;
        private long minimumScoreDenominator;
        private long maximumScoreNumerator;
        private long maximumScoreDenominator;
        private Result<T> output = new Result();

        public ComputeScores(boolean unboundedScores, int minimumScoreNumerator, int minimumScoreDenominator, int maximumScoreNumerator, int maximumScoreDenominator) {
            this.unboundedScores = unboundedScores;
            this.minimumScoreNumerator = minimumScoreNumerator;
            this.minimumScoreDenominator = minimumScoreDenominator;
            this.maximumScoreNumerator = maximumScoreNumerator;
            this.maximumScoreDenominator = maximumScoreDenominator;
        }

        public void reduce(Iterable<Tuple3<T, T, IntValue>> values, Collector<Result<T>> out) throws Exception {
            int count = 0;
            Tuple3<T, T, IntValue> edge = null;
            Iterator<Tuple3<T, T, IntValue>> i$ = values.iterator();
            while (i$.hasNext()) {
                Tuple3<T, T, IntValue> next;
                edge = next = i$.next();
                ++count;
            }
            int distinctNeighbors = ((IntValue)edge.f2).getValue() - count;
            if (this.unboundedScores || (long)count * this.minimumScoreDenominator >= (long)distinctNeighbors * this.minimumScoreNumerator && (long)count * this.maximumScoreDenominator < (long)distinctNeighbors * this.maximumScoreNumerator) {
                this.output.f0 = edge.f0;
                this.output.f1 = edge.f1;
                ((IntValue)((Tuple2)this.output.f2).f0).setValue(count);
                ((IntValue)((Tuple2)this.output.f2).f1).setValue(distinctNeighbors);
                out.collect(this.output);
            }
        }
    }

    private static class GenerateGroupPairs<T extends CopyableValue<T>>
    implements GroupReduceFunction<Tuple4<IntValue, T, T, IntValue>, Tuple3<T, T, IntValue>> {
        private final int groupSize;
        private boolean initialized = false;
        private List<Tuple3<T, T, IntValue>> visited;

        public GenerateGroupPairs(int groupSize) {
            this.groupSize = groupSize;
            this.visited = new ArrayList<Tuple3<T, T, IntValue>>(groupSize);
        }

        public void reduce(Iterable<Tuple4<IntValue, T, T, IntValue>> values, Collector<Tuple3<T, T, IntValue>> out) throws Exception {
            int visitedCount = 0;
            for (Tuple4<IntValue, T, T, IntValue> edge : values) {
                int i;
                for (i = 0; i < visitedCount; ++i) {
                    Tuple3<T, T, IntValue> prior = this.visited.get(i);
                    prior.f1 = edge.f2;
                    int oldValue = ((IntValue)prior.f2).getValue();
                    long degreeSum = oldValue + ((IntValue)edge.f3).getValue();
                    if (degreeSum > Integer.MAX_VALUE) {
                        throw new RuntimeException("Degree sum overflows IntValue");
                    }
                    ((IntValue)prior.f2).setValue((int)degreeSum);
                    out.collect(prior);
                    ((IntValue)prior.f2).setValue(oldValue);
                }
                if (visitedCount >= this.groupSize) continue;
                if (!this.initialized) {
                    this.initialized = true;
                    for (i = 0; i < this.groupSize; ++i) {
                        Tuple3 tuple = new Tuple3();
                        tuple.f0 = ((CopyableValue)edge.f2).copy();
                        tuple.f2 = ((IntValue)edge.f3).copy();
                        this.visited.add(tuple);
                    }
                } else {
                    Tuple3<T, T, IntValue> copy = this.visited.get(visitedCount);
                    ((CopyableValue)edge.f2).copyTo(copy.f0);
                    ((IntValue)edge.f3).copyTo((IntValue)copy.f2);
                }
                ++visitedCount;
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1; 2; 3"})
    private static class GenerateGroups<T>
    implements FlatMapFunction<Tuple4<IntValue, T, T, IntValue>, Tuple4<IntValue, T, T, IntValue>> {
        private GenerateGroups() {
        }

        public void flatMap(Tuple4<IntValue, T, T, IntValue> value, Collector<Tuple4<IntValue, T, T, IntValue>> out) throws Exception {
            int spans = ((IntValue)value.f0).getValue();
            for (int idx = 0; idx < spans; ++idx) {
                ((IntValue)value.f0).setValue(idx);
                out.collect(value);
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->1; 1->2"})
    private static class GenerateGroupSpans<T, ET>
    implements GroupReduceFunction<Edge<T, Tuple2<ET, LongValue>>, Tuple4<IntValue, T, T, IntValue>> {
        private final int groupSize;
        private IntValue groupSpansValue = new IntValue();
        private Tuple4<IntValue, T, T, IntValue> output = new Tuple4((Object)this.groupSpansValue, null, null, (Object)new IntValue());

        public GenerateGroupSpans(int groupSize) {
            this.groupSize = groupSize;
        }

        public void reduce(Iterable<Edge<T, Tuple2<ET, LongValue>>> values, Collector<Tuple4<IntValue, T, T, IntValue>> out) throws Exception {
            int groupCount = 0;
            int groupSpans = 1;
            this.groupSpansValue.setValue(groupSpans);
            for (Edge<T, Tuple2<ET, LongValue>> edge : values) {
                long degree = ((LongValue)((Tuple2)edge.f2).f1).getValue();
                if (degree > Integer.MAX_VALUE) {
                    throw new RuntimeException("Degree overflows IntValue");
                }
                this.output.f1 = edge.f0;
                this.output.f2 = edge.f1;
                ((IntValue)this.output.f3).setValue((int)degree);
                out.collect(this.output);
                if (++groupCount != this.groupSize) continue;
                groupCount = 0;
                this.groupSpansValue.setValue(++groupSpans);
            }
        }
    }
}

