/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.metric.undirected;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.accumulators.LongMaximum;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.AbstractGraphAnalytic;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeDegreePair;
import org.apache.flink.types.LongValue;

public class EdgeMetrics<K extends Comparable<K>, VV, EV>
extends AbstractGraphAnalytic<K, VV, EV, Result> {
    private static final String TRIANGLE_TRIPLET_COUNT = "triangleTripletCount";
    private static final String RECTANGLE_TRIPLET_COUNT = "rectangleTripletCount";
    private static final String MAXIMUM_TRIANGLE_TRIPLETS = "maximumTriangleTriplets";
    private static final String MAXIMUM_RECTANGLE_TRIPLETS = "maximumRectangleTriplets";
    private EdgeMetricsHelper<K> edgeMetricsHelper;
    private boolean reduceOnTargetId = false;
    private int parallelism = -1;

    public EdgeMetrics<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId = reduceOnTargetId;
        return this;
    }

    public EdgeMetrics<K, VV, EV> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public EdgeMetrics<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        DataSet edgeDegreePair = (DataSet)input.run(new EdgeDegreePair().setReduceOnTargetId(this.reduceOnTargetId).setParallelism(this.parallelism));
        Operator edgeStats = ((ReduceOperator)((MapOperator)((MapOperator)edgeDegreePair.map(new EdgeStats()).setParallelism(this.parallelism)).name("Edge stats")).groupBy(new int[]{0}).reduce(new SumEdgeStats()).setCombineHint(ReduceOperatorBase.CombineHint.HASH).setParallelism(this.parallelism)).name("Sum edge stats");
        this.edgeMetricsHelper = new EdgeMetricsHelper();
        edgeStats.output(this.edgeMetricsHelper).setParallelism(this.parallelism).name("Edge metrics");
        return this;
    }

    @Override
    public Result getResult() {
        long triangleTripletCount = (Long)this.edgeMetricsHelper.getAccumulator(this.env, TRIANGLE_TRIPLET_COUNT);
        long rectangleTripletCount = (Long)this.edgeMetricsHelper.getAccumulator(this.env, RECTANGLE_TRIPLET_COUNT);
        long maximumTriangleTriplets = (Long)this.edgeMetricsHelper.getAccumulator(this.env, MAXIMUM_TRIANGLE_TRIPLETS);
        long maximumRectangleTriplets = (Long)this.edgeMetricsHelper.getAccumulator(this.env, MAXIMUM_RECTANGLE_TRIPLETS);
        return new Result(triangleTripletCount, rectangleTripletCount, maximumTriangleTriplets, maximumRectangleTriplets);
    }

    public static class Result {
        private long triangleTripletCount;
        private long rectangleTripletCount;
        private long maximumTriangleTriplets;
        private long maximumRectangleTriplets;

        public Result(long triangleTripletCount, long rectangleTripletCount, long maximumTriangleTriplets, long maximumRectangleTriplets) {
            this.triangleTripletCount = triangleTripletCount;
            this.rectangleTripletCount = rectangleTripletCount;
            this.maximumTriangleTriplets = maximumTriangleTriplets;
            this.maximumRectangleTriplets = maximumRectangleTriplets;
        }

        public long getNumberOfTriangleTriplets() {
            return this.triangleTripletCount;
        }

        public long getNumberOfRectangleTriplets() {
            return this.rectangleTripletCount;
        }

        public long getMaximumTriangleTriplets() {
            return this.maximumTriangleTriplets;
        }

        public long getMaximumRectangleTriplets() {
            return this.maximumRectangleTriplets;
        }

        public String toString() {
            NumberFormat nf = NumberFormat.getInstance();
            return "triangle triplet count: " + nf.format(this.triangleTripletCount) + "; rectangle triplet count: " + nf.format(this.rectangleTripletCount) + "; maximum triangle triplets: " + nf.format(this.maximumTriangleTriplets) + "; maximum rectangle triplets: " + nf.format(this.maximumRectangleTriplets);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.triangleTripletCount).append(this.rectangleTripletCount).append(this.maximumTriangleTriplets).append(this.maximumRectangleTriplets).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.triangleTripletCount, rhs.triangleTripletCount).append(this.rectangleTripletCount, rhs.rectangleTripletCount).append(this.maximumTriangleTriplets, rhs.maximumTriangleTriplets).append(this.maximumRectangleTriplets, rhs.maximumRectangleTriplets).isEquals();
        }
    }

    private static class EdgeMetricsHelper<T extends Comparable<T>>
    extends AnalyticHelper<Tuple3<T, LongValue, LongValue>> {
        private long triangleTripletCount;
        private long rectangleTripletCount;
        private long maximumTriangleTriplets;
        private long maximumRectangleTriplets;

        private EdgeMetricsHelper() {
        }

        public void writeRecord(Tuple3<T, LongValue, LongValue> record) throws IOException {
            long degree = ((LongValue)record.f1).getValue();
            long lowDegree = ((LongValue)record.f2).getValue();
            long highDegree = degree - lowDegree;
            long triangleTriplets = lowDegree * (lowDegree - 1L) / 2L;
            long rectangleTriplets = triangleTriplets + lowDegree * highDegree;
            this.triangleTripletCount += triangleTriplets;
            this.rectangleTripletCount += rectangleTriplets;
            this.maximumTriangleTriplets = Math.max(this.maximumTriangleTriplets, triangleTriplets);
            this.maximumRectangleTriplets = Math.max(this.maximumRectangleTriplets, rectangleTriplets);
        }

        public void close() throws IOException {
            this.addAccumulator(EdgeMetrics.TRIANGLE_TRIPLET_COUNT, new LongCounter(this.triangleTripletCount));
            this.addAccumulator(EdgeMetrics.RECTANGLE_TRIPLET_COUNT, new LongCounter(this.rectangleTripletCount));
            this.addAccumulator(EdgeMetrics.MAXIMUM_TRIANGLE_TRIPLETS, new LongMaximum(this.maximumTriangleTriplets));
            this.addAccumulator(EdgeMetrics.MAXIMUM_RECTANGLE_TRIPLETS, new LongMaximum(this.maximumRectangleTriplets));
        }
    }

    private static class SumEdgeStats<T>
    implements ReduceFunction<Tuple3<T, LongValue, LongValue>> {
        private SumEdgeStats() {
        }

        public Tuple3<T, LongValue, LongValue> reduce(Tuple3<T, LongValue, LongValue> value1, Tuple3<T, LongValue, LongValue> value2) throws Exception {
            ((LongValue)value1.f2).setValue(((LongValue)value1.f2).getValue() + ((LongValue)value2.f2).getValue());
            return value1;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 2.1->1"})
    private static class EdgeStats<T extends Comparable<T>, ET>
    implements MapFunction<Edge<T, Tuple3<ET, LongValue, LongValue>>, Tuple3<T, LongValue, LongValue>> {
        private LongValue zero = new LongValue(0L);
        private LongValue one = new LongValue(1L);
        private Tuple3<T, LongValue, LongValue> output = new Tuple3();

        private EdgeStats() {
        }

        public Tuple3<T, LongValue, LongValue> map(Edge<T, Tuple3<ET, LongValue, LongValue>> edge) throws Exception {
            long targetDegree;
            Tuple3 degrees = (Tuple3)edge.f2;
            this.output.f0 = edge.f0;
            this.output.f1 = degrees.f1;
            long sourceDegree = ((LongValue)degrees.f1).getValue();
            this.output.f2 = sourceDegree < (targetDegree = ((LongValue)degrees.f2).getValue()) || sourceDegree == targetDegree && ((Comparable)edge.f0).compareTo(edge.f1) < 0 ? this.one : this.zero;
            return this.output;
        }
    }
}

