/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.metric;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.Utils;
import org.apache.flink.graph.AbstractGraphAnalytic;
import org.apache.flink.graph.Graph;
import org.apache.flink.util.AbstractID;

public class ChecksumHashCode<K, VV, EV>
extends AbstractGraphAnalytic<K, VV, EV, Utils.ChecksumHashCode> {
    private String verticesId = new AbstractID().toString();
    private String edgesId = new AbstractID().toString();

    public ChecksumHashCode<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        input.getVertices().output((OutputFormat)new Utils.ChecksumHashCodeHelper(this.verticesId)).name("ChecksumHashCode vertices");
        input.getEdges().output((OutputFormat)new Utils.ChecksumHashCodeHelper(this.edgesId)).name("ChecksumHashCode edges");
        return this;
    }

    @Override
    public Utils.ChecksumHashCode getResult() {
        JobExecutionResult res = this.env.getLastJobExecutionResult();
        Utils.ChecksumHashCode checksum = (Utils.ChecksumHashCode)res.getAccumulatorResult(this.verticesId);
        checksum.add((Utils.ChecksumHashCode)res.getAccumulatorResult(this.edgesId));
        return checksum;
    }
}

