/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeDegreePair;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class TriangleListing<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Tuple3<K, K, K>> {
    private OptionalBoolean sortTriangleVertices = new OptionalBoolean(false, false);
    private int littleParallelism = -1;

    public TriangleListing<K, VV, EV> setSortTriangleVertices(boolean sortTriangleVertices) {
        this.sortTriangleVertices.set(sortTriangleVertices);
        return this;
    }

    public TriangleListing<K, VV, EV> setLittleParallelism(int littleParallelism) {
        Preconditions.checkArgument((littleParallelism > 0 || littleParallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.littleParallelism = littleParallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return TriangleListing.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!TriangleListing.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        TriangleListing rhs = (TriangleListing)other;
        this.sortTriangleVertices.mergeWith(rhs.sortTriangleVertices);
        this.littleParallelism = this.littleParallelism == -1 ? rhs.littleParallelism : (rhs.littleParallelism == -1 ? this.littleParallelism : Math.min(this.littleParallelism, rhs.littleParallelism));
        return true;
    }

    @Override
    public DataSet<Tuple3<K, K, K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator filteredByID = ((FlatMapOperator)input.getEdges().flatMap(new FilterByID()).setParallelism(this.littleParallelism)).name("Filter by ID");
        DataSet pairDegree = (DataSet)input.run(new EdgeDegreePair().setParallelism(this.littleParallelism));
        Operator filteredByDegree = ((FlatMapOperator)pairDegree.flatMap(new FilterByDegree()).setParallelism(this.littleParallelism)).name("Filter by degree");
        Operator triplets = filteredByDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new GenerateTriplets()).name("Generate triplets");
        Operator triangles = triplets.join((DataSet)filteredByID, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with(new ProjectTriangles()).name("Triangle listing");
        if (this.sortTriangleVertices.get()) {
            triangles = triangles.map(new SortTriangleVertices()).name("Sort triangle vertices");
        }
        return triangles;
    }

    private static final class SortTriangleVertices<T extends Comparable<T>>
    implements MapFunction<Tuple3<T, T, T>, Tuple3<T, T, T>> {
        private SortTriangleVertices() {
        }

        public Tuple3<T, T, T> map(Tuple3<T, T, T> value) throws Exception {
            if (((Comparable)value.f0).compareTo(value.f1) > 0) {
                Comparable temp_val = (Comparable)value.f0;
                value.f0 = value.f1;
                if (temp_val.compareTo(value.f2) <= 0) {
                    value.f1 = temp_val;
                } else {
                    value.f1 = value.f2;
                    value.f2 = temp_val;
                }
            }
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1; 2"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0; 1"})
    private static final class ProjectTriangles<T>
    implements JoinFunction<Tuple3<T, T, T>, Tuple2<T, T>, Tuple3<T, T, T>> {
        private ProjectTriangles() {
        }

        public Tuple3<T, T, T> join(Tuple3<T, T, T> triplet, Tuple2<T, T> edge) throws Exception {
            return triplet;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class GenerateTriplets<T extends CopyableValue<T>>
    implements GroupReduceFunction<Tuple2<T, T>, Tuple3<T, T, T>> {
        private Tuple3<T, T, T> output = new Tuple3();
        private List<T> visited = new ArrayList<T>();

        private GenerateTriplets() {
        }

        public void reduce(Iterable<Tuple2<T, T>> values, Collector<Tuple3<T, T, T>> out) throws Exception {
            int visitedCount = 0;
            Iterator<Tuple2<T, T>> iter = values.iterator();
            while (true) {
                Tuple2<T, T> edge = iter.next();
                this.output.f0 = edge.f0;
                this.output.f2 = edge.f1;
                for (int i = 0; i < visitedCount; ++i) {
                    this.output.f1 = this.visited.get(i);
                    out.collect(this.output);
                }
                if (!iter.hasNext()) break;
                if (visitedCount == this.visited.size()) {
                    this.visited.add(((CopyableValue)edge.f1).copy());
                } else {
                    ((CopyableValue)edge.f1).copyTo(this.visited.get(visitedCount));
                }
                ++visitedCount;
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static final class FilterByDegree<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, Tuple3<ET, LongValue, LongValue>>, Tuple2<T, T>> {
        private Tuple2<T, T> edge = new Tuple2();

        private FilterByDegree() {
        }

        public void flatMap(Edge<T, Tuple3<ET, LongValue, LongValue>> value, Collector<Tuple2<T, T>> out) throws Exception {
            long targetDegree;
            Tuple3 degrees = (Tuple3)value.f2;
            long sourceDegree = ((LongValue)degrees.f1).getValue();
            if (sourceDegree < (targetDegree = ((LongValue)degrees.f2).getValue()) || sourceDegree == targetDegree && ((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.edge.f0 = value.f0;
                this.edge.f1 = value.f1;
                out.collect(this.edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static final class FilterByID<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, ET>, Tuple2<T, T>> {
        private Tuple2<T, T> edge = new Tuple2();

        private FilterByID() {
        }

        public void flatMap(Edge<T, ET> value, Collector<Tuple2<T, T>> out) throws Exception {
            if (((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.edge.f0 = value.f0;
                this.edge.f1 = value.f1;
                out.collect(this.edge);
            }
        }
    }
}

