/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.graph.AbstractGraphAnalytic;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.library.clustering.undirected.TriangleCount;
import org.apache.flink.graph.library.metric.undirected.VertexMetrics;
import org.apache.flink.types.CopyableValue;

public class GlobalClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends AbstractGraphAnalytic<K, VV, EV, Result> {
    private TriangleCount<K, VV, EV> triangleCount;
    private VertexMetrics<K, VV, EV> vertexMetrics;
    private int littleParallelism = -1;

    public GlobalClusteringCoefficient<K, VV, EV> setLittleParallelism(int littleParallelism) {
        this.littleParallelism = littleParallelism;
        return this;
    }

    public GlobalClusteringCoefficient<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        this.triangleCount = new TriangleCount().setLittleParallelism(this.littleParallelism);
        input.run(this.triangleCount);
        this.vertexMetrics = new VertexMetrics().setParallelism(this.littleParallelism);
        input.run(this.vertexMetrics);
        return this;
    }

    @Override
    public Result getResult() {
        long numberOfTriangles = 3L * this.triangleCount.getResult();
        return new Result(this.vertexMetrics.getResult().getNumberOfTriplets(), numberOfTriangles);
    }

    public static class Result {
        private long tripletCount;
        private long triangleCount;

        public Result(long tripletCount, long triangleCount) {
            this.tripletCount = tripletCount;
            this.triangleCount = triangleCount;
        }

        public long getNumberOfTriplets() {
            return this.tripletCount;
        }

        public long getNumberOfTriangles() {
            return this.triangleCount;
        }

        public double getGlobalClusteringCoefficientScore() {
            return this.tripletCount == 0L ? Double.NaN : (double)this.triangleCount / (double)this.tripletCount;
        }

        public String toString() {
            return "triplet count: " + this.tripletCount + ", triangle count: " + this.triangleCount + ", global clustering coefficient: " + this.getGlobalClusteringCoefficientScore();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.tripletCount).append(this.triangleCount).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.tripletCount, rhs.tripletCount).append(this.triangleCount, rhs.triangleCount).isEquals();
        }
    }
}

