/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.directed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.EdgeOrder;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.directed.EdgeDegreesPair;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class TriangleListing<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Result<K>> {
    private OptionalBoolean sortTriangleVertices = new OptionalBoolean(false, false);
    private int littleParallelism = -1;

    public TriangleListing<K, VV, EV> setSortTriangleVertices(boolean sortTriangleVertices) {
        this.sortTriangleVertices.set(sortTriangleVertices);
        return this;
    }

    public TriangleListing<K, VV, EV> setLittleParallelism(int littleParallelism) {
        Preconditions.checkArgument((littleParallelism > 0 || littleParallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.littleParallelism = littleParallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return TriangleListing.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!TriangleListing.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        TriangleListing rhs = (TriangleListing)other;
        this.sortTriangleVertices.mergeWith(rhs.sortTriangleVertices);
        this.littleParallelism = this.littleParallelism == -1 ? rhs.littleParallelism : (rhs.littleParallelism == -1 ? this.littleParallelism : Math.min(this.littleParallelism, rhs.littleParallelism));
        return true;
    }

    @Override
    public DataSet<Result<K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator filteredByID = ((GroupReduceOperator)((MapOperator)((MapOperator)input.getEdges().map(new OrderByID()).setParallelism(this.littleParallelism)).name("Order by ID")).groupBy(new int[]{0, 1}).reduceGroup(new ReduceBitmask()).setParallelism(this.littleParallelism)).name("Flatten by ID");
        DataSet pairDegrees = (DataSet)input.run(new EdgeDegreesPair().setParallelism(this.littleParallelism));
        Operator filteredByDegree = ((GroupReduceOperator)((MapOperator)((MapOperator)pairDegrees.map(new OrderByDegree()).setParallelism(this.littleParallelism)).name("Order by degree")).groupBy(new int[]{0, 1}).reduceGroup(new ReduceBitmask()).setParallelism(this.littleParallelism)).name("Flatten by degree");
        Operator triplets = filteredByDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new GenerateTriplets()).name("Generate triplets");
        Operator triangles = triplets.join((DataSet)filteredByID, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with(new ProjectTriangles()).name("Triangle listing");
        if (this.sortTriangleVertices.get()) {
            triangles = triangles.map(new SortTriangleVertices()).name("Sort triangle vertices");
        }
        return triangles;
    }

    public static class Result<T>
    extends Tuple4<T, T, T, ByteValue> {
        public Result() {
        }

        public Result(T value0, T value1, T value2, ByteValue value3) {
            super(value0, value1, value2, (Object)value3);
        }

        public String toVerboseString() {
            byte bitmask = ((ByteValue)this.f3).getValue();
            return "1st vertex ID: " + this.f0 + ", 2nd vertex ID: " + this.f1 + ", 3rd vertex ID: " + this.f2 + ", edge directions: " + this.f0 + this.maskToString(bitmask, 4) + this.f1 + ", " + this.f0 + this.maskToString(bitmask, 2) + this.f2 + ", " + this.f1 + this.maskToString(bitmask, 0) + this.f2;
        }

        private String maskToString(byte mask, int shift) {
            int edgeMask = mask >>> shift & 3;
            if (edgeMask == EdgeOrder.FORWARD.getBitmask()) {
                return "->";
            }
            if (edgeMask == EdgeOrder.REVERSE.getBitmask()) {
                return "<-";
            }
            if (edgeMask == EdgeOrder.MUTUAL.getBitmask()) {
                return "<->";
            }
            throw new IllegalArgumentException("Bitmask is missing an edge (mask = " + mask + ", shift = " + shift);
        }
    }

    private static final class SortTriangleVertices<T extends Comparable<T>>
    implements MapFunction<Result<T>, Result<T>> {
        private SortTriangleVertices() {
        }

        public Result<T> map(Result<T> value) throws Exception {
            if (((Comparable)value.f0).compareTo(value.f1) > 0) {
                byte bitmask = ((ByteValue)value.f3).getValue();
                Comparable temp_val = (Comparable)value.f0;
                value.f0 = value.f1;
                if (temp_val.compareTo(value.f2) < 0) {
                    value.f1 = temp_val;
                    int f0f1 = (bitmask & 0x20) >>> 1 | (bitmask & 0x10) << 1;
                    int f0f2 = (bitmask & 0xC) >>> 2;
                    int f1f2 = (bitmask & 3) << 2;
                    ((ByteValue)value.f3).setValue((byte)(f0f1 | f0f2 | f1f2));
                } else {
                    value.f1 = value.f2;
                    value.f2 = temp_val;
                    int f0f1 = (bitmask & 3) << 4;
                    int f0f2 = (bitmask & 0x20) >>> 3 | (bitmask & 0x10) >>> 1;
                    int f1f2 = (bitmask & 8) >>> 3 | (bitmask & 4) >>> 1;
                    ((ByteValue)value.f3).setValue((byte)(f0f1 | f0f2 | f1f2));
                }
            }
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1; 2"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0; 1"})
    private static final class ProjectTriangles<T>
    implements JoinFunction<Tuple4<T, T, T, ByteValue>, Tuple3<T, T, ByteValue>, Result<T>> {
        private Result<T> output = new Result<Object>(null, null, null, new ByteValue());

        private ProjectTriangles() {
        }

        public Result<T> join(Tuple4<T, T, T, ByteValue> triplet, Tuple3<T, T, ByteValue> edge) throws Exception {
            this.output.f0 = triplet.f0;
            this.output.f1 = triplet.f1;
            this.output.f2 = triplet.f2;
            ((ByteValue)this.output.f3).setValue((byte)(((ByteValue)triplet.f3).getValue() | ((ByteValue)edge.f2).getValue()));
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class GenerateTriplets<T extends CopyableValue<T>>
    implements GroupReduceFunction<Tuple3<T, T, ByteValue>, Tuple4<T, T, T, ByteValue>> {
        private Tuple4<T, T, T, ByteValue> output = new Tuple4(null, null, null, (Object)new ByteValue());
        private List<Tuple2<T, ByteValue>> visited = new ArrayList<Tuple2<T, ByteValue>>();

        private GenerateTriplets() {
        }

        public void reduce(Iterable<Tuple3<T, T, ByteValue>> values, Collector<Tuple4<T, T, T, ByteValue>> out) throws Exception {
            int visitedCount = 0;
            Iterator<Tuple3<T, T, ByteValue>> iter = values.iterator();
            while (true) {
                Tuple3<T, T, ByteValue> edge = iter.next();
                byte bitmask = ((ByteValue)edge.f2).getValue();
                this.output.f0 = edge.f0;
                this.output.f2 = edge.f1;
                for (int i = 0; i < visitedCount; ++i) {
                    Tuple2<T, ByteValue> previous = this.visited.get(i);
                    this.output.f1 = previous.f0;
                    ((ByteValue)this.output.f3).setValue((byte)(((ByteValue)previous.f1).getValue() | bitmask));
                    out.collect(this.output);
                }
                if (!iter.hasNext()) break;
                byte shiftedBitmask = (byte)(bitmask << 2);
                if (visitedCount == this.visited.size()) {
                    this.visited.add(new Tuple2(((CopyableValue)edge.f1).copy(), (Object)new ByteValue(shiftedBitmask)));
                } else {
                    Tuple2<T, ByteValue> update = this.visited.get(visitedCount);
                    ((CopyableValue)edge.f1).copyTo(update.f0);
                    ((ByteValue)update.f1).setValue(shiftedBitmask);
                }
                ++visitedCount;
            }
        }
    }

    private static final class OrderByDegree<T extends Comparable<T>, ET>
    implements MapFunction<Edge<T, Tuple3<ET, VertexDegrees.Degrees, VertexDegrees.Degrees>>, Tuple3<T, T, ByteValue>> {
        private ByteValue forward = new ByteValue((byte)(EdgeOrder.FORWARD.getBitmask() << 2));
        private ByteValue reverse = new ByteValue((byte)(EdgeOrder.REVERSE.getBitmask() << 2));
        private Tuple3<T, T, ByteValue> output = new Tuple3();

        private OrderByDegree() {
        }

        public Tuple3<T, T, ByteValue> map(Edge<T, Tuple3<ET, VertexDegrees.Degrees, VertexDegrees.Degrees>> value) throws Exception {
            long targetDegree;
            Tuple3 degrees = (Tuple3)value.f2;
            long sourceDegree = ((VertexDegrees.Degrees)((Object)degrees.f1)).getDegree().getValue();
            if (sourceDegree < (targetDegree = ((VertexDegrees.Degrees)((Object)degrees.f2)).getDegree().getValue()) || sourceDegree == targetDegree && ((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.output.f0 = value.f0;
                this.output.f1 = value.f1;
                this.output.f2 = this.forward;
            } else {
                this.output.f0 = value.f1;
                this.output.f1 = value.f0;
                this.output.f2 = this.reverse;
            }
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static final class ReduceBitmask<T>
    implements GroupReduceFunction<Tuple3<T, T, ByteValue>, Tuple3<T, T, ByteValue>> {
        private ReduceBitmask() {
        }

        public void reduce(Iterable<Tuple3<T, T, ByteValue>> values, Collector<Tuple3<T, T, ByteValue>> out) throws Exception {
            Tuple3<T, T, ByteValue> output = null;
            byte bitmask = 0;
            Iterator<Tuple3<T, T, ByteValue>> i$ = values.iterator();
            while (i$.hasNext()) {
                Tuple3<T, T, ByteValue> value;
                output = value = i$.next();
                bitmask = (byte)(bitmask | ((ByteValue)value.f2).getValue());
            }
            ((ByteValue)output.f2).setValue(bitmask);
            out.collect(output);
        }
    }

    private static final class OrderByID<T extends Comparable<T>, ET>
    implements MapFunction<Edge<T, ET>, Tuple3<T, T, ByteValue>> {
        private ByteValue forward = new ByteValue(EdgeOrder.FORWARD.getBitmask());
        private ByteValue reverse = new ByteValue(EdgeOrder.REVERSE.getBitmask());
        private Tuple3<T, T, ByteValue> output = new Tuple3();

        private OrderByID() {
        }

        public Tuple3<T, T, ByteValue> map(Edge<T, ET> value) throws Exception {
            if (((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.output.f0 = value.f0;
                this.output.f1 = value.f1;
                this.output.f2 = this.forward;
            } else {
                this.output.f0 = value.f1;
                this.output.f1 = value.f0;
                this.output.f2 = this.reverse;
            }
            return this.output;
        }
    }
}

