/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.directed;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.graph.AbstractGraphAnalytic;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.library.clustering.directed.TriangleListing;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.AbstractID;

public class TriangleCount<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends AbstractGraphAnalytic<K, VV, EV, Long> {
    private String id = new AbstractID().toString();
    private int littleParallelism = -1;

    public TriangleCount<K, VV, EV> setLittleParallelism(int littleParallelism) {
        this.littleParallelism = littleParallelism;
        return this;
    }

    public TriangleCount<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        DataSet triangles = (DataSet)input.run(new TriangleListing().setSortTriangleVertices(false).setLittleParallelism(this.littleParallelism));
        triangles.output((OutputFormat)new Utils.CountHelper(this.id)).name("Count triangles");
        return this;
    }

    @Override
    public Long getResult() {
        return (Long)this.env.getLastJobExecutionResult().getAccumulatorResult(this.id);
    }
}

