/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.directed;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.library.clustering.directed.TriangleListing;
import org.apache.flink.graph.utils.Murmur3_32;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class LocalClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Result<K>> {
    private OptionalBoolean includeZeroDegreeVertices = new OptionalBoolean(true, true);
    private int littleParallelism = -1;

    public LocalClusteringCoefficient<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices.set(includeZeroDegreeVertices);
        return this;
    }

    public LocalClusteringCoefficient<K, VV, EV> setLittleParallelism(int littleParallelism) {
        Preconditions.checkArgument((littleParallelism > 0 || littleParallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.littleParallelism = littleParallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return LocalClusteringCoefficient.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!LocalClusteringCoefficient.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        LocalClusteringCoefficient rhs = (LocalClusteringCoefficient)other;
        if (this.includeZeroDegreeVertices.conflictsWith(rhs.includeZeroDegreeVertices)) {
            return false;
        }
        this.includeZeroDegreeVertices.mergeWith(rhs.includeZeroDegreeVertices);
        this.littleParallelism = this.littleParallelism == -1 ? rhs.littleParallelism : (rhs.littleParallelism == -1 ? this.littleParallelism : Math.min(this.littleParallelism, rhs.littleParallelism));
        return true;
    }

    @Override
    public DataSet<Result<K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet triangles = (DataSet)input.run(new TriangleListing().setLittleParallelism(this.littleParallelism));
        Operator triangleVertices = triangles.flatMap(new SplitTriangles()).name("Split triangle vertices");
        Operator vertexTriangleCount = triangleVertices.groupBy(new int[]{0}).reduce(new CountTriangles()).setCombineHint(ReduceOperatorBase.CombineHint.HASH).name("Count triangles");
        DataSet vertexDegree = (DataSet)input.run(new VertexDegrees().setIncludeZeroDegreeVertices(this.includeZeroDegreeVertices.get()).setParallelism(this.littleParallelism));
        return ((JoinOperator)vertexDegree.leftOuterJoin((DataSet)vertexTriangleCount).where(new int[]{0}).equalTo(new int[]{0}).with(new JoinVertexDegreeWithTriangleCount()).setParallelism(this.littleParallelism)).name("Clustering coefficient");
    }

    public static class Result<T>
    extends Vertex<T, Tuple2<LongValue, LongValue>> {
        public static final int HASH_SEED = 933365956;
        private Murmur3_32 hasher = new Murmur3_32(933365956);

        public Result() {
            this.f1 = new Tuple2();
        }

        public LongValue getDegree() {
            return (LongValue)((Tuple2)this.f1).f0;
        }

        public LongValue getTriangleCount() {
            return (LongValue)((Tuple2)this.f1).f1;
        }

        public double getLocalClusteringCoefficientScore() {
            long degree = this.getDegree().getValue();
            long neighborPairs = degree * (degree - 1L);
            return neighborPairs == 0L ? Double.NaN : (double)this.getTriangleCount().getValue() / (double)neighborPairs;
        }

        public String toVerboseString() {
            return "Vertex ID: " + this.f0 + ", vertex degree: " + this.getDegree() + ", triangle count: " + this.getTriangleCount() + ", local clustering coefficient: " + this.getLocalClusteringCoefficientScore();
        }

        public int hashCode() {
            return this.hasher.reset().hash(this.f0.hashCode()).hash(((LongValue)((Tuple2)this.f1).f0).getValue()).hash(((LongValue)((Tuple2)this.f1).f1).getValue()).hash();
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1.0->1.0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0"})
    private static class JoinVertexDegreeWithTriangleCount<T>
    implements JoinFunction<Vertex<T, VertexDegrees.Degrees>, Tuple2<T, LongValue>, Result<T>> {
        private LongValue zero = new LongValue(0L);
        private Result<T> output = new Result();

        private JoinVertexDegreeWithTriangleCount() {
        }

        public Result<T> join(Vertex<T, VertexDegrees.Degrees> vertexAndDegree, Tuple2<T, LongValue> vertexAndTriangleCount) throws Exception {
            this.output.f0 = vertexAndDegree.f0;
            ((Tuple2)this.output.f1).f0 = ((VertexDegrees.Degrees)((Object)vertexAndDegree.f1)).f0;
            ((Tuple2)this.output.f1).f1 = vertexAndTriangleCount == null ? this.zero : (LongValue)vertexAndTriangleCount.f1;
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class CountTriangles<T>
    implements ReduceFunction<Tuple2<T, LongValue>> {
        private CountTriangles() {
        }

        public Tuple2<T, LongValue> reduce(Tuple2<T, LongValue> left, Tuple2<T, LongValue> right) throws Exception {
            ((LongValue)left.f1).setValue(((LongValue)left.f1).getValue() + ((LongValue)right.f1).getValue());
            return left;
        }
    }

    private static class SplitTriangles<T>
    implements FlatMapFunction<TriangleListing.Result<T>, Tuple2<T, LongValue>> {
        private LongValue one = new LongValue(1L);
        private LongValue two = new LongValue(2L);
        private Tuple2<T, LongValue> output = new Tuple2();

        private SplitTriangles() {
        }

        public void flatMap(TriangleListing.Result<T> value, Collector<Tuple2<T, LongValue>> out) throws Exception {
            byte bitmask = ((ByteValue)value.f3).getValue();
            this.output.f0 = value.f0;
            this.output.f1 = (bitmask & 3) == 3 ? this.two : this.one;
            out.collect(this.output);
            this.output.f0 = value.f1;
            this.output.f1 = (bitmask & 0xC) == 12 ? this.two : this.one;
            out.collect(this.output);
            this.output.f0 = value.f2;
            this.output.f1 = (bitmask & 0x30) == 48 ? this.two : this.one;
            out.collect(this.output);
        }
    }
}

