/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.spargel.GatherFunction;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.graph.spargel.ScatterFunction;

public class SingleSourceShortestPaths<K, VV>
implements GraphAlgorithm<K, VV, Double, DataSet<Vertex<K, Double>>> {
    private final K srcVertexId;
    private final Integer maxIterations;

    public SingleSourceShortestPaths(K srcVertexId, Integer maxIterations) {
        this.srcVertexId = srcVertexId;
        this.maxIterations = maxIterations;
    }

    @Override
    public DataSet<Vertex<K, Double>> run(Graph<K, VV, Double> input) {
        return input.mapVertices(new InitVerticesMapper(this.srcVertexId)).runScatterGatherIteration(new MinDistanceMessenger(), new VertexDistanceUpdater(), this.maxIterations).getVertices();
    }

    public static final class VertexDistanceUpdater<K>
    extends GatherFunction<K, Double, Double> {
        @Override
        public void updateVertex(Vertex<K, Double> vertex, MessageIterator<Double> inMessages) {
            Double minDistance = Double.MAX_VALUE;
            for (double msg : inMessages) {
                if (!(msg < minDistance)) continue;
                minDistance = msg;
            }
            if (vertex.getValue() > minDistance) {
                this.setNewVertexValue(minDistance);
            }
        }
    }

    public static final class MinDistanceMessenger<K>
    extends ScatterFunction<K, Double, Double, Double> {
        @Override
        public void sendMessages(Vertex<K, Double> vertex) {
            if (vertex.getValue() < Double.POSITIVE_INFINITY) {
                for (Edge edge : this.getEdges()) {
                    this.sendMessageTo(edge.getTarget(), vertex.getValue() + (Double)edge.getValue());
                }
            }
        }
    }

    public static final class InitVerticesMapper<K, VV>
    implements MapFunction<Vertex<K, VV>, Double> {
        private K srcVertexId;

        public InitVerticesMapper(K srcId) {
            this.srcVertexId = srcId;
        }

        public Double map(Vertex<K, VV> value) {
            if (value.f0.equals(this.srcVertexId)) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
    }
}

