/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.gsa.ApplyFunction;
import org.apache.flink.graph.gsa.GatherFunction;
import org.apache.flink.graph.gsa.Neighbor;
import org.apache.flink.graph.gsa.SumFunction;
import org.apache.flink.graph.utils.NullValueEdgeMapper;
import org.apache.flink.types.NullValue;

public class GSAConnectedComponents<K, VV extends Comparable<VV>, EV>
implements GraphAlgorithm<K, VV, EV, DataSet<Vertex<K, VV>>> {
    private Integer maxIterations;

    public GSAConnectedComponents(Integer maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public DataSet<Vertex<K, VV>> run(Graph<K, VV, EV> graph) throws Exception {
        TypeInformation valueTypeInfo = ((TupleTypeInfo)graph.getVertices().getType()).getTypeAt(1);
        Graph undirectedGraph = graph.mapEdges(new NullValueEdgeMapper()).getUndirected();
        return undirectedGraph.runGatherSumApplyIteration(new GatherNeighborIds(valueTypeInfo), new SelectMinId(valueTypeInfo), new UpdateComponentId(valueTypeInfo), this.maxIterations).getVertices();
    }

    private static final class UpdateComponentId<K, VV extends Comparable<VV>>
    extends ApplyFunction<K, VV, VV>
    implements ResultTypeQueryable<VV> {
        private final TypeInformation<VV> typeInformation;

        private UpdateComponentId(TypeInformation<VV> typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public void apply(VV summedValue, VV origValue) {
            if (summedValue.compareTo(origValue) < 0) {
                this.setResult(summedValue);
            }
        }

        public TypeInformation<VV> getProducedType() {
            return this.typeInformation;
        }
    }

    private static final class SelectMinId<VV extends Comparable<VV>>
    extends SumFunction<VV, NullValue, VV>
    implements ResultTypeQueryable<VV> {
        private final TypeInformation<VV> typeInformation;

        private SelectMinId(TypeInformation<VV> typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public VV sum(VV newValue, VV currentValue) {
            return newValue.compareTo(currentValue) < 0 ? newValue : currentValue;
        }

        public TypeInformation<VV> getProducedType() {
            return this.typeInformation;
        }
    }

    private static final class GatherNeighborIds<VV extends Comparable<VV>>
    extends GatherFunction<VV, NullValue, VV>
    implements ResultTypeQueryable<VV> {
        private final TypeInformation<VV> typeInformation;

        private GatherNeighborIds(TypeInformation<VV> typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public VV gather(Neighbor<VV, NullValue> neighbor) {
            return (VV)((Comparable)neighbor.getNeighborValue());
        }

        public TypeInformation<VV> getProducedType() {
            return this.typeInformation;
        }
    }
}

