/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.spargel.GatherFunction;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.graph.spargel.ScatterFunction;
import org.apache.flink.graph.utils.NullValueEdgeMapper;
import org.apache.flink.types.NullValue;

public class ConnectedComponents<K, VV extends Comparable<VV>, EV>
implements GraphAlgorithm<K, VV, EV, DataSet<Vertex<K, VV>>> {
    private Integer maxIterations;

    public ConnectedComponents(Integer maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public DataSet<Vertex<K, VV>> run(Graph<K, VV, EV> graph) throws Exception {
        TypeInformation valueTypeInfo = ((TupleTypeInfo)graph.getVertices().getType()).getTypeAt(1);
        Graph undirectedGraph = graph.mapEdges(new NullValueEdgeMapper()).getUndirected();
        return undirectedGraph.runScatterGatherIteration(new CCMessenger(valueTypeInfo), new CCUpdater(), this.maxIterations).getVertices();
    }

    public static final class CCUpdater<K, VV extends Comparable<VV>>
    extends GatherFunction<K, VV, VV> {
        @Override
        public void updateVertex(Vertex<K, VV> vertex, MessageIterator<VV> messages) throws Exception {
            Comparable current;
            Comparable min = current = (Comparable)vertex.getValue();
            for (Comparable msg : messages) {
                if (msg.compareTo(min) >= 0) continue;
                min = msg;
            }
            if (!min.equals(current)) {
                this.setNewVertexValue(min);
            }
        }
    }

    public static final class CCMessenger<K, VV extends Comparable<VV>>
    extends ScatterFunction<K, VV, VV, NullValue>
    implements ResultTypeQueryable<VV> {
        private final TypeInformation<VV> typeInformation;

        public CCMessenger(TypeInformation<VV> typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public void sendMessages(Vertex<K, VV> vertex) throws Exception {
            this.sendMessageToAllNeighbors(vertex.getValue());
        }

        public TypeInformation<VV> getProducedType() {
            return this.typeInformation;
        }
    }
}

