/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import java.util.Iterator;
import java.util.TreeMap;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.spargel.GatherFunction;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.graph.spargel.ScatterFunction;

public class CommunityDetection<K>
implements GraphAlgorithm<K, Long, Double, Graph<K, Long, Double>> {
    private int maxIterations;
    private double delta;

    public CommunityDetection(int maxIterations, double delta) {
        this.maxIterations = maxIterations;
        this.delta = delta;
    }

    @Override
    public Graph<K, Long, Double> run(Graph<K, Long, Double> graph) {
        MapOperator initializedVertices = graph.getVertices().map(new AddScoreToVertexValuesMapper());
        Graph graphWithScoredVertices = Graph.fromDataSet(initializedVertices, graph.getEdges(), graph.getContext()).getUndirected();
        return graphWithScoredVertices.runScatterGatherIteration(new LabelMessenger(), new VertexLabelUpdater(this.delta), this.maxIterations).mapVertices(new RemoveScoreFromVertexValuesMapper());
    }

    public static final class RemoveScoreFromVertexValuesMapper<K>
    implements MapFunction<Vertex<K, Tuple2<Long, Double>>, Long> {
        public Long map(Vertex<K, Tuple2<Long, Double>> vertex) throws Exception {
            return (Long)vertex.getValue().f0;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0"})
    public static final class AddScoreToVertexValuesMapper<K>
    implements MapFunction<Vertex<K, Long>, Vertex<K, Tuple2<Long, Double>>> {
        public Vertex<K, Tuple2<Long, Double>> map(Vertex<K, Long> vertex) {
            return new Vertex<K, Tuple2>(vertex.getId(), new Tuple2((Object)vertex.getValue(), (Object)1.0));
        }
    }

    public static final class VertexLabelUpdater<K>
    extends GatherFunction<K, Tuple2<Long, Double>, Tuple2<Long, Double>> {
        private double delta;

        public VertexLabelUpdater(double delta) {
            this.delta = delta;
        }

        @Override
        public void updateVertex(Vertex<K, Tuple2<Long, Double>> vertex, MessageIterator<Tuple2<Long, Double>> inMessages) throws Exception {
            TreeMap<Long, Double> receivedLabelsWithScores = new TreeMap<Long, Double>();
            TreeMap<Long, Double> labelsWithHighestScore = new TreeMap<Long, Double>();
            for (Tuple2<Long, Double> message : inMessages) {
                long receivedLabel = (Long)message.f0;
                double receivedScore = (Double)message.f1;
                if (receivedLabelsWithScores.containsKey(receivedLabel)) {
                    double newScore = receivedScore + (Double)receivedLabelsWithScores.get(receivedLabel);
                    receivedLabelsWithScores.put(receivedLabel, newScore);
                } else {
                    receivedLabelsWithScores.put(receivedLabel, receivedScore);
                }
                if (labelsWithHighestScore.containsKey(receivedLabel)) {
                    double currentScore = (Double)labelsWithHighestScore.get(receivedLabel);
                    if (!(currentScore < receivedScore)) continue;
                    labelsWithHighestScore.put(receivedLabel, receivedScore);
                    continue;
                }
                labelsWithHighestScore.put(receivedLabel, receivedScore);
            }
            if (receivedLabelsWithScores.size() > 0) {
                double maxScore = Double.MIN_VALUE;
                long maxScoreLabel = (Long)vertex.getValue().f0;
                Iterator i$ = receivedLabelsWithScores.keySet().iterator();
                while (i$.hasNext()) {
                    long curLabel = (Long)i$.next();
                    if (!((Double)receivedLabelsWithScores.get(curLabel) > maxScore)) continue;
                    maxScore = (Double)receivedLabelsWithScores.get(curLabel);
                    maxScoreLabel = curLabel;
                }
                double highestScore = (Double)labelsWithHighestScore.get(maxScoreLabel);
                if (maxScoreLabel != (Long)vertex.getValue().f0) {
                    highestScore -= this.delta / (double)this.getSuperstepNumber();
                }
                this.setNewVertexValue(new Tuple2((Object)maxScoreLabel, (Object)highestScore));
            }
        }
    }

    public static final class LabelMessenger<K>
    extends ScatterFunction<K, Tuple2<Long, Double>, Tuple2<Long, Double>, Double> {
        @Override
        public void sendMessages(Vertex<K, Tuple2<Long, Double>> vertex) throws Exception {
            for (Edge edge : this.getEdges()) {
                this.sendMessageTo(edge.getTarget(), new Tuple2(vertex.getValue().f0, (Object)((Double)vertex.getValue().f1 * (Double)edge.getValue())));
            }
        }
    }
}

