/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator.random;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.flink.graph.generator.random.BlockInfo;
import org.apache.flink.graph.generator.random.RandomGenerable;
import org.apache.flink.graph.generator.random.RandomGenerableFactory;

public abstract class AbstractGeneratorFactory<T extends RandomGenerator>
implements RandomGenerableFactory<T> {
    public static final int MAXIMUM_BLOCK_COUNT = 32768;

    protected abstract int getMinimumCyclesPerBlock();

    protected abstract RandomGenerable<T> next();

    @Override
    public List<BlockInfo<T>> getRandomGenerables(long elementCount, int cyclesPerElement) {
        long cycles = elementCount * (long)cyclesPerElement;
        int blockCount = Math.min((int)Math.ceil((float)cycles / (float)this.getMinimumCyclesPerBlock()), 32768);
        long elementsPerBlock = elementCount / (long)blockCount;
        long elementRemainder = elementCount % (long)blockCount;
        ArrayList<BlockInfo<T>> blocks = new ArrayList<BlockInfo<T>>(blockCount);
        long blockStart = 0L;
        for (int blockIndex = 0; blockIndex < blockCount; ++blockIndex) {
            if ((long)blockIndex == (long)blockCount - elementRemainder) {
                ++elementsPerBlock;
            }
            RandomGenerable<T> randomGenerable = this.next();
            blocks.add(new BlockInfo<T>(randomGenerable, blockIndex, blockCount, blockStart, elementsPerBlock));
            blockStart += elementsPerBlock;
        }
        return blocks;
    }
}

