/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public class StarGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long vertexCount;

    public StarGraph(ExecutionEnvironment env, long vertexCount) {
        if (vertexCount <= 0L) {
            throw new IllegalArgumentException("Vertex count must be greater than zero");
        }
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(1L, this.vertexCount - 1L);
        Operator edges = ((FlatMapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).flatMap((FlatMapFunction)new LinkVertexToCenter()).setParallelism(this.parallelism)).name("Star graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public class LinkVertexToCenter
    implements FlatMapFunction<LongValue, Edge<LongValue, NullValue>> {
        private LongValue center = new LongValue(0L);
        private Edge<LongValue, NullValue> center_to_leaf = new Edge<Object, NullValue>(this.center, null, NullValue.getInstance());
        private Edge<LongValue, NullValue> leaf_to_center = new Edge<LongValue, NullValue>(null, this.center, NullValue.getInstance());

        public void flatMap(LongValue leaf, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            this.center_to_leaf.f1 = leaf;
            out.collect(this.center_to_leaf);
            this.leaf_to_center.f0 = leaf;
            out.collect(this.leaf_to_center);
        }
    }
}

