/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public class SingletonEdgeGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long vertexPairCount;

    public SingletonEdgeGraph(ExecutionEnvironment env, long vertexPairCount) {
        if (vertexPairCount <= 0L) {
            throw new IllegalArgumentException("Vertex pair count must be greater than zero");
        }
        this.env = env;
        this.vertexPairCount = vertexPairCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        long vertexCount = 2L * this.vertexPairCount;
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(0L, vertexCount - 1L);
        Operator edges = ((MapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).map((MapFunction)new LinkVertexToSingletonNeighbor()).setParallelism(this.parallelism)).name("Complete graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    private static class LinkVertexToSingletonNeighbor
    implements MapFunction<LongValue, Edge<LongValue, NullValue>> {
        private LongValue source = new LongValue();
        private LongValue target = new LongValue();
        private Edge<LongValue, NullValue> edge = new Edge<LongValue, NullValue>(this.source, this.target, NullValue.getInstance());

        private LinkVertexToSingletonNeighbor() {
        }

        public Edge<LongValue, NullValue> map(LongValue value) throws Exception {
            long val = value.getValue();
            this.source.setValue(val);
            if (val % 2L == 0L) {
                this.target.setValue(val + 1L);
            } else {
                this.target.setValue(val - 1L);
            }
            return this.edge;
        }
    }
}

