/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GridGraph;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class PathGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long vertexCount;

    public PathGraph(ExecutionEnvironment env, long vertexCount) {
        if (vertexCount <= 0L) {
            throw new IllegalArgumentException("Vertex count must be greater than zero");
        }
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        return new GridGraph(this.env).addDimension(this.vertexCount, false).setParallelism(this.parallelism).generate();
    }
}

