/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GridGraph;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class HypercubeGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long dimensions;

    public HypercubeGraph(ExecutionEnvironment env, long dimensions) {
        if (dimensions <= 0L) {
            throw new IllegalArgumentException("Number of dimensions must be greater than zero");
        }
        this.env = env;
        this.dimensions = dimensions;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        GridGraph graph = new GridGraph(this.env);
        int i = 0;
        while ((long)i < this.dimensions) {
            graph.addDimension(2L, false);
            ++i;
        }
        return graph.setParallelism(this.parallelism).generate();
    }
}

