/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public class GridGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private List<Tuple2<Long, Boolean>> dimensions = new ArrayList<Tuple2<Long, Boolean>>();
    private long vertexCount = 1L;

    public GridGraph(ExecutionEnvironment env) {
        this.env = env;
    }

    public GridGraph addDimension(long size, boolean wrapEndpoints) {
        if (size <= 1L) {
            throw new IllegalArgumentException("Dimension size must be greater than 1");
        }
        this.vertexCount *= size;
        if (size == 2L) {
            wrapEndpoints = false;
        }
        this.dimensions.add((Tuple2<Long, Boolean>)new Tuple2((Object)size, (Object)wrapEndpoints));
        return this;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        if (this.dimensions.isEmpty()) {
            throw new RuntimeException("No dimensions added to GridGraph");
        }
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(0L, this.vertexCount - 1L);
        Operator edges = ((FlatMapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).flatMap((FlatMapFunction)new LinkVertexToNeighbors(this.vertexCount, this.dimensions)).setParallelism(this.parallelism)).name("Grid graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public class LinkVertexToNeighbors
    implements FlatMapFunction<LongValue, Edge<LongValue, NullValue>> {
        private long vertexCount;
        private List<Tuple2<Long, Boolean>> dimensions;
        private LongValue target = new LongValue();
        private Edge<LongValue, NullValue> edge = new Edge<LongValue, NullValue>(null, this.target, NullValue.getInstance());

        public LinkVertexToNeighbors(long vertexCount, List<Tuple2<Long, Boolean>> dimensions) {
            this.vertexCount = vertexCount;
            this.dimensions = dimensions;
        }

        public void flatMap(LongValue source, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            this.edge.f0 = source;
            long val = source.getValue();
            long increment = this.vertexCount;
            long remainder = val;
            for (Tuple2<Long, Boolean> dimension : this.dimensions) {
                long index = remainder / (increment /= ((Long)dimension.f0).longValue());
                if (index > 0L) {
                    this.target.setValue(val - increment);
                    out.collect(this.edge);
                } else if (((Boolean)dimension.f1).booleanValue()) {
                    this.target.setValue(val + increment * ((Long)dimension.f0 - 1L));
                    out.collect(this.edge);
                }
                if (index < (Long)dimension.f0 - 1L) {
                    this.target.setValue(val + increment);
                    out.collect(this.edge);
                } else if (((Boolean)dimension.f1).booleanValue()) {
                    this.target.setValue(val - increment * ((Long)dimension.f0 - 1L));
                    out.collect(this.edge);
                }
                remainder %= increment;
            }
        }
    }
}

