/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public class GraphGeneratorUtils {
    public static DataSet<Vertex<LongValue, NullValue>> vertexSequence(ExecutionEnvironment env, int parallelism, long vertexCount) {
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(0L, vertexCount - 1L);
        DataSource vertexLabels = (DataSource)((DataSource)env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(parallelism)).name("Vertex iterators");
        return ((MapOperator)vertexLabels.map((MapFunction)new CreateVertex()).setParallelism(parallelism)).name("Vertex sequence");
    }

    public static <K, EV> DataSet<Vertex<K, NullValue>> vertexSet(DataSet<Edge<K, EV>> edges, int parallelism) {
        Operator vertexSet = ((FlatMapOperator)edges.flatMap(new EmitSrcAndTarget()).setParallelism(parallelism)).name("Emit source and target labels");
        return ((DistinctOperator)vertexSet.distinct().setParallelism(parallelism)).name("Emit vertex labels");
    }

    private static final class EmitSrcAndTarget<K, EV>
    implements FlatMapFunction<Edge<K, EV>, Vertex<K, NullValue>> {
        private Vertex<K, NullValue> output = new Vertex<Object, NullValue>(null, new NullValue());

        private EmitSrcAndTarget() {
        }

        public void flatMap(Edge<K, EV> value, Collector<Vertex<K, NullValue>> out) throws Exception {
            this.output.f0 = value.f0;
            out.collect(this.output);
            this.output.f0 = value.f1;
            out.collect(this.output);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    private static class CreateVertex
    implements MapFunction<LongValue, Vertex<LongValue, NullValue>> {
        private Vertex<LongValue, NullValue> vertex = new Vertex<Object, NullValue>(null, NullValue.getInstance());

        private CreateVertex() {
        }

        public Vertex<LongValue, NullValue> map(LongValue value) throws Exception {
            this.vertex.f0 = value;
            return this.vertex;
        }
    }
}

