/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class EmptyGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long vertexCount;

    public EmptyGraph(ExecutionEnvironment env, long vertexCount) {
        if (vertexCount <= 0L) {
            throw new IllegalArgumentException("Vertex count must be greater than zero");
        }
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        TupleTypeInfo typeInformation = new TupleTypeInfo(new TypeInformation[]{ValueTypeInfo.LONG_VALUE_TYPE_INFO, ValueTypeInfo.LONG_VALUE_TYPE_INFO, ValueTypeInfo.NULL_VALUE_TYPE_INFO});
        DataSource edges = (DataSource)((DataSource)this.env.fromCollection(Collections.emptyList(), (TypeInformation)typeInformation).setParallelism(this.parallelism)).name("Empty edge set");
        return Graph.fromDataSet(vertices, edges, this.env);
    }
}

