/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.AbstractGraphGenerator;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public class CompleteGraph
extends AbstractGraphGenerator<LongValue, NullValue, NullValue> {
    private final ExecutionEnvironment env;
    private long vertexCount;

    public CompleteGraph(ExecutionEnvironment env, long vertexCount) {
        if (vertexCount <= 0L) {
            throw new IllegalArgumentException("Vertex count must be greater than zero");
        }
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(0L, this.vertexCount - 1L);
        Operator edges = ((FlatMapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).flatMap((FlatMapFunction)new LinkVertexToAll(this.vertexCount)).setParallelism(this.parallelism)).name("Complete graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public class LinkVertexToAll
    implements FlatMapFunction<LongValue, Edge<LongValue, NullValue>> {
        private final long vertexCount;
        private LongValue target = new LongValue();
        private Edge<LongValue, NullValue> edge = new Edge<LongValue, NullValue>(null, this.target, NullValue.getInstance());

        public LinkVertexToAll(long vertex_count) {
            this.vertexCount = vertex_count;
        }

        public void flatMap(LongValue source, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            this.edge.f0 = source;
            long s = source.getValue();
            long t = (s + 1L) % this.vertexCount;
            while (s != t) {
                this.target.setValue(t);
                out.collect(this.edge);
                if (++t != this.vertexCount) continue;
                t = 0L;
            }
        }
    }
}

