/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateVertexValues<K, OLD, NEW, EV>
extends GraphAlgorithmWrappingGraph<K, OLD, EV, K, NEW, EV> {
    private TranslateFunction<OLD, NEW> translator;
    private int parallelism = -1;

    public TranslateVertexValues(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    public TranslateVertexValues<K, OLD, NEW, EV> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return TranslateVertexValues.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingGraph other) {
        Preconditions.checkNotNull((Object)other);
        if (!TranslateVertexValues.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        TranslateVertexValues rhs = (TranslateVertexValues)other;
        if (this.translator != rhs.translator) {
            return false;
        }
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public Graph<K, NEW, EV> runInternal(Graph<K, OLD, EV> input) throws Exception {
        DataSet<Vertex<K, NEW>> translatedVertices = Translate.translateVertexValues(input.getVertices(), this.translator, this.parallelism);
        return Graph.fromDataSet(translatedVertices, input.getEdges(), input.getContext());
    }
}

