/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateGraphIds<OLD, NEW, VV, EV>
extends GraphAlgorithmWrappingGraph<OLD, VV, EV, NEW, VV, EV> {
    private TranslateFunction<OLD, NEW> translator;
    private int parallelism = -1;

    public TranslateGraphIds(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    public TranslateGraphIds<OLD, NEW, VV, EV> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return TranslateGraphIds.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingGraph other) {
        Preconditions.checkNotNull((Object)other);
        if (!TranslateGraphIds.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        TranslateGraphIds rhs = (TranslateGraphIds)other;
        if (this.translator != rhs.translator) {
            return false;
        }
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public Graph<NEW, VV, EV> runInternal(Graph<OLD, VV, EV> input) throws Exception {
        DataSet<Vertex<NEW, VV>> translatedVertices = Translate.translateVertexIds(input.getVertices(), this.translator, this.parallelism);
        DataSet<Edge<NEW, EV>> translatedEdges = Translate.translateEdgeIds(input.getEdges(), this.translator, this.parallelism);
        return Graph.fromDataSet(translatedVertices, translatedEdges, input.getContext());
    }
}

