/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateEdgeValues<K, VV, OLD, NEW>
extends GraphAlgorithmWrappingGraph<K, VV, OLD, K, VV, NEW> {
    private TranslateFunction<OLD, NEW> translator;
    private int parallelism = -1;

    public TranslateEdgeValues(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    public TranslateEdgeValues<K, VV, OLD, NEW> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return TranslateEdgeValues.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingGraph other) {
        Preconditions.checkNotNull((Object)other);
        if (!TranslateEdgeValues.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        TranslateEdgeValues rhs = (TranslateEdgeValues)other;
        if (this.translator != rhs.translator) {
            return false;
        }
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public Graph<K, VV, NEW> runInternal(Graph<K, VV, OLD> input) throws Exception {
        DataSet<Edge<K, NEW>> translatedEdges = Translate.translateEdgeValues(input.getEdges(), this.translator, this.parallelism);
        return Graph.fromDataSet(input.getVertices(), translatedEdges, input.getContext());
    }
}

