/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.simple.undirected;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class Simplify<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAlgorithmWrappingGraph<K, VV, EV, K, VV, EV> {
    private boolean clipAndFlip;
    private int parallelism = -1;

    public Simplify(boolean clipAndFlip) {
        this.clipAndFlip = clipAndFlip;
    }

    public Simplify<K, VV, EV> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return Simplify.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingGraph other) {
        Preconditions.checkNotNull((Object)other);
        if (!Simplify.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        Simplify rhs = (Simplify)other;
        if (this.clipAndFlip != rhs.clipAndFlip) {
            return false;
        }
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public Graph<K, VV, EV> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator edges = ((DistinctOperator)((FlatMapOperator)((FlatMapOperator)input.getEdges().flatMap(new SymmetrizeAndRemoveSelfLoops(this.clipAndFlip)).setParallelism(this.parallelism)).name("Remove self-loops")).distinct(new int[]{0, 1}).setParallelism(this.parallelism)).name("Remove duplicate edges");
        return Graph.fromDataSet(input.getVertices(), edges, input.getContext());
    }

    private static class SymmetrizeAndRemoveSelfLoops<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, ET>, Edge<T, ET>> {
        private boolean clipAndFlip;

        public SymmetrizeAndRemoveSelfLoops(boolean clipAndFlip) {
            this.clipAndFlip = clipAndFlip;
        }

        public void flatMap(Edge<T, ET> value, Collector<Edge<T, ET>> out) throws Exception {
            int comparison = ((Comparable)value.f0).compareTo(value.f1);
            if (this.clipAndFlip && comparison > 0 || !this.clipAndFlip && comparison != 0) {
                out.collect(value);
                Comparable temp = (Comparable)value.f0;
                value.f0 = value.f1;
                value.f1 = temp;
                out.collect(value);
            }
        }
    }
}

