/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.filter.undirected;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class MaximumDegree<K, VV, EV>
extends GraphAlgorithmWrappingGraph<K, VV, EV, K, VV, EV> {
    private long maximumDegree;
    private OptionalBoolean reduceOnTargetId = new OptionalBoolean(false, false);
    private OptionalBoolean broadcastHighDegreeVertices = new OptionalBoolean(false, false);
    private int parallelism = -1;

    public MaximumDegree(long maximumDegree) {
        Preconditions.checkArgument((maximumDegree > 0L ? 1 : 0) != 0, (Object)"Maximum degree must be greater than zero");
        this.maximumDegree = maximumDegree;
    }

    public MaximumDegree<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId.set(reduceOnTargetId);
        return this;
    }

    public MaximumDegree<K, VV, EV> setBroadcastHighDegreeVertices(boolean broadcastHighDegreeVertices) {
        this.broadcastHighDegreeVertices.set(broadcastHighDegreeVertices);
        return this;
    }

    public MaximumDegree<K, VV, EV> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return MaximumDegree.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingGraph other) {
        Preconditions.checkNotNull((Object)other);
        if (!MaximumDegree.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        MaximumDegree rhs = (MaximumDegree)other;
        if (this.maximumDegree != rhs.maximumDegree) {
            return false;
        }
        this.reduceOnTargetId.mergeWith(rhs.reduceOnTargetId);
        this.broadcastHighDegreeVertices.mergeWith(rhs.broadcastHighDegreeVertices);
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public Graph<K, VV, EV> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet vertexDegree = (DataSet)input.run(new VertexDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        Operator highDegreeVertices = ((FlatMapOperator)vertexDegree.flatMap(new DegreeFilter(this.maximumDegree)).setParallelism(this.parallelism)).name("Filter high-degree vertices");
        JoinOperatorBase.JoinHint joinHint = this.broadcastHighDegreeVertices.get() ? JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND : JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND;
        Operator vertices = ((JoinOperator)input.getVertices().leftOuterJoin((DataSet)highDegreeVertices, joinHint).where(new int[]{0}).equalTo(new int[]{0}).with(new ProjectVertex()).setParallelism(this.parallelism)).name("Project low-degree vertices");
        Operator edges = ((JoinOperator)((JoinOperator)((JoinOperator)input.getEdges().leftOuterJoin((DataSet)highDegreeVertices, joinHint).where(new int[]{this.reduceOnTargetId.get() ? 1 : 0}).equalTo(new int[]{0}).with(new ProjectEdge()).setParallelism(this.parallelism)).name("Project low-degree edges by " + (this.reduceOnTargetId.get() ? "target" : "source"))).leftOuterJoin((DataSet)highDegreeVertices, joinHint).where(new int[]{this.reduceOnTargetId.get() ? 0 : 1}).equalTo(new int[]{0}).with(new ProjectEdge()).setParallelism(this.parallelism)).name("Project low-degree edges by " + (this.reduceOnTargetId.get() ? "source" : "target"));
        return Graph.fromDataSet(vertices, edges, input.getContext());
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1; 2"})
    private static class ProjectEdge<T, ET>
    implements FlatJoinFunction<Edge<T, ET>, Tuple1<T>, Edge<T, ET>> {
        private ProjectEdge() {
        }

        public void join(Edge<T, ET> edge, Tuple1<T> id, Collector<Edge<T, ET>> out) throws Exception {
            if (id == null) {
                out.collect(edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1"})
    private static class ProjectVertex<T, VT>
    implements FlatJoinFunction<Vertex<T, VT>, Tuple1<T>, Vertex<T, VT>> {
        private ProjectVertex() {
        }

        public void join(Vertex<T, VT> vertex, Tuple1<T> id, Collector<Vertex<T, VT>> out) throws Exception {
            if (id == null) {
                out.collect(vertex);
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class DegreeFilter<K>
    implements FlatMapFunction<Vertex<K, LongValue>, Tuple1<K>> {
        private long maximumDegree;
        private Tuple1<K> output = new Tuple1();

        public DegreeFilter(long maximumDegree) {
            this.maximumDegree = maximumDegree;
        }

        public void flatMap(Vertex<K, LongValue> value, Collector<Tuple1<K>> out) throws Exception {
            if (((LongValue)value.f1).getValue() > this.maximumDegree) {
                this.output.f0 = value.f0;
                out.collect(this.output);
            }
        }
    }
}

