/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.undirected;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeSourceDegree;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Preconditions;

public class EdgeDegreePair<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Edge<K, Tuple3<EV, LongValue, LongValue>>> {
    private OptionalBoolean reduceOnTargetId = new OptionalBoolean(false, false);
    private int parallelism = -1;

    public EdgeDegreePair<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId.set(reduceOnTargetId);
        return this;
    }

    public EdgeDegreePair<K, VV, EV> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return EdgeDegreePair.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!EdgeSourceDegree.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        EdgeDegreePair rhs = (EdgeDegreePair)other;
        this.reduceOnTargetId.mergeWith(rhs.reduceOnTargetId);
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public DataSet<Edge<K, Tuple3<EV, LongValue, LongValue>>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet edgeSourceDegrees = (DataSet)input.run(new EdgeSourceDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        DataSet vertexDegrees = (DataSet)input.run(new VertexDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        return ((JoinOperator)edgeSourceDegrees.join(vertexDegrees, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinEdgeDegreeWithVertexDegree()).setParallelism(this.parallelism)).name("Edge target degree");
    }
}

