/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.directed;

import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Preconditions;

public class VertexOutDegree<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Vertex<K, LongValue>> {
    private OptionalBoolean includeZeroDegreeVertices = new OptionalBoolean(false, true);
    private int parallelism = -1;

    public VertexOutDegree<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices.set(includeZeroDegreeVertices);
        return this;
    }

    public VertexOutDegree<K, VV, EV> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be greater than zero.");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return VertexOutDegree.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!VertexOutDegree.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        VertexOutDegree rhs = (VertexOutDegree)other;
        if (this.includeZeroDegreeVertices.conflictsWith(rhs.includeZeroDegreeVertices)) {
            return false;
        }
        this.includeZeroDegreeVertices.mergeWith(rhs.includeZeroDegreeVertices);
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public DataSet<Vertex<K, LongValue>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator sourceIds = ((MapOperator)input.getEdges().map(new DegreeAnnotationFunctions.MapEdgeToSourceId()).setParallelism(this.parallelism)).name("Edge to source ID");
        Operator sourceDegree = ((ReduceOperator)sourceIds.groupBy(new int[]{0}).reduce(new DegreeAnnotationFunctions.DegreeCount()).setCombineHint(ReduceOperatorBase.CombineHint.HASH).setParallelism(this.parallelism)).name("Degree count");
        if (this.includeZeroDegreeVertices.get()) {
            sourceDegree = ((JoinOperator)input.getVertices().leftOuterJoin((DataSet)sourceDegree).where(new int[]{0}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinVertexWithVertexDegree()).setParallelism(this.parallelism)).name("Zero degree vertices");
        }
        return sourceDegree;
    }
}

