/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.directed;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.util.Preconditions;

public class EdgeSourceDegrees<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Edge<K, Tuple2<EV, VertexDegrees.Degrees>>> {
    private int parallelism = -1;

    public EdgeSourceDegrees<K, VV, EV> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return EdgeSourceDegrees.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!EdgeSourceDegrees.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        EdgeSourceDegrees rhs = (EdgeSourceDegrees)other;
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public DataSet<Edge<K, Tuple2<EV, VertexDegrees.Degrees>>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet vertexDegrees = (DataSet)input.run(new VertexDegrees().setParallelism(this.parallelism));
        return ((JoinOperator)input.getEdges().join(vertexDegrees, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{0}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinEdgeWithVertexDegree()).setParallelism(this.parallelism)).name("Edge source degrees");
    }
}

