/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.directed;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.asm.degree.annotate.directed.EdgeSourceDegrees;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.util.Preconditions;

public class EdgeDegreesPair<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Edge<K, Tuple3<EV, VertexDegrees.Degrees, VertexDegrees.Degrees>>> {
    private int parallelism = -1;

    public EdgeDegreesPair<K, VV, EV> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Override
    protected String getAlgorithmName() {
        return EdgeDegreesPair.class.getName();
    }

    @Override
    protected boolean mergeConfiguration(GraphAlgorithmWrappingDataSet other) {
        Preconditions.checkNotNull((Object)other);
        if (!EdgeDegreesPair.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        EdgeDegreesPair rhs = (EdgeDegreesPair)other;
        this.parallelism = this.parallelism == -1 ? rhs.parallelism : (rhs.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, rhs.parallelism));
        return true;
    }

    @Override
    public DataSet<Edge<K, Tuple3<EV, VertexDegrees.Degrees, VertexDegrees.Degrees>>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet edgeSourceDegrees = (DataSet)input.run(new EdgeSourceDegrees().setParallelism(this.parallelism));
        DataSet vertexDegrees = (DataSet)input.run(new VertexDegrees().setParallelism(this.parallelism));
        return ((JoinOperator)edgeSourceDegrees.join(vertexDegrees, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinEdgeDegreeWithVertexDegree()).setParallelism(this.parallelism)).name("Edge target degree");
    }
}

