/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.LongValue;

public class DegreeAnnotationFunctions {

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1; 2.0; 2.1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0; 1->2.2"})
    public static class JoinEdgeDegreeWithVertexDegree<K, EV, D>
    implements JoinFunction<Edge<K, Tuple2<EV, D>>, Vertex<K, D>, Edge<K, Tuple3<EV, D, D>>> {
        private Tuple3<EV, D, D> valueAndDegrees = new Tuple3();
        private Edge<K, Tuple3<EV, D, D>> output = new Edge<Object, Tuple3<EV, D, D>>(null, null, this.valueAndDegrees);

        public Edge<K, Tuple3<EV, D, D>> join(Edge<K, Tuple2<EV, D>> edge, Vertex<K, D> vertex) throws Exception {
            Tuple2 valueAndDegree = (Tuple2)edge.f2;
            this.output.f0 = edge.f0;
            this.output.f1 = edge.f1;
            this.valueAndDegrees.f0 = valueAndDegree.f0;
            this.valueAndDegrees.f1 = valueAndDegree.f1;
            this.valueAndDegrees.f2 = vertex.f1;
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1; 2->2.0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0; 1->2.1"})
    public static class JoinEdgeWithVertexDegree<K, EV, D>
    implements JoinFunction<Edge<K, EV>, Vertex<K, D>, Edge<K, Tuple2<EV, D>>> {
        private Tuple2<EV, D> valueAndDegree = new Tuple2();
        private Edge<K, Tuple2<EV, D>> output = new Edge<Object, Tuple2<EV, D>>(null, null, this.valueAndDegree);

        public Edge<K, Tuple2<EV, D>> join(Edge<K, EV> edge, Vertex<K, D> vertex) throws Exception {
            this.output.f0 = edge.f0;
            this.output.f1 = edge.f1;
            this.valueAndDegree.f0 = edge.f2;
            this.valueAndDegree.f1 = vertex.f1;
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0"})
    public static class JoinVertexWithVertexDegree<K, VV>
    implements JoinFunction<Vertex<K, VV>, Vertex<K, LongValue>, Vertex<K, LongValue>> {
        private LongValue zero = new LongValue(0L);
        private Vertex<K, LongValue> output = new Vertex();

        public Vertex<K, LongValue> join(Vertex<K, VV> vertex, Vertex<K, LongValue> vertexDegree) throws Exception {
            this.output.f0 = vertex.f0;
            this.output.f1 = vertexDegree == null ? this.zero : (LongValue)vertexDegree.f1;
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    public static class DegreeCount<K>
    implements ReduceFunction<Vertex<K, LongValue>> {
        public Vertex<K, LongValue> reduce(Vertex<K, LongValue> left, Vertex<K, LongValue> right) throws Exception {
            LongValue count = (LongValue)left.f1;
            count.setValue(count.getValue() + ((LongValue)right.f1).getValue());
            return left;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1->0"})
    public static class MapEdgeToTargetId<K, EV>
    implements MapFunction<Edge<K, EV>, Vertex<K, LongValue>> {
        private Vertex<K, LongValue> output = new Vertex<Object, LongValue>(null, new LongValue(1L));

        public Vertex<K, LongValue> map(Edge<K, EV> value) throws Exception {
            this.output.f0 = value.f1;
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    public static class MapEdgeToSourceId<K, EV>
    implements MapFunction<Edge<K, EV>, Vertex<K, LongValue>> {
        private Vertex<K, LongValue> output = new Vertex<Object, LongValue>(null, new LongValue(1L));

        public Vertex<K, LongValue> map(Edge<K, EV> value) throws Exception {
            this.output.f0 = value.f0;
            return this.output;
        }
    }
}

